/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import org.api4.java.common.metric.IDistanceMetric;

public class MoveSplitMerge
implements IDistanceMetric {
    private double c;

    public MoveSplitMerge(double c) {
        this.c = c;
    }

    @Override
    public double distance(double[] a, double[] b) {
        int i;
        int n = a.length;
        int m = b.length;
        double[][] cost = new double[n][m];
        cost[0][0] = Math.abs(a[0] - b[0]);
        for (i = 1; i < n; ++i) {
            cost[i][0] = cost[i - 1][0] + this.c(a[i], a[i - 1], b[0]);
        }
        for (int j = 1; j < m; ++j) {
            cost[0][j] = cost[0][j - 1] + this.c(b[j], a[0], b[j - 1]);
        }
        for (i = 1; i < n; ++i) {
            for (int j = 1; j < m; ++j) {
                double costMove = cost[i - 1][j - 1] + Math.abs(a[i] - b[j]);
                double cost2 = cost[i - 1][j] + this.c(a[i], a[i - 1], b[j]);
                double cost3 = cost[i][j - 1] + this.c(b[j], a[i], b[j - 1]);
                cost[i][j] = Math.min(costMove, Math.min(cost2, cost3));
            }
        }
        return cost[n - 1][m - 1];
    }

    private double c(double a, double aBefore, double b) {
        if (aBefore <= a && a <= b || aBefore >= a && a >= b) {
            return this.c;
        }
        return this.c + Math.min(Math.abs(a - aBefore), Math.abs(a - b));
    }
}

