/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import ai.libs.jaicore.basic.metric.EuclideanDistance;
import ai.libs.jaicore.basic.transform.vector.IVectorTransform;
import ai.libs.jaicore.basic.transform.vector.NormalizeByStdTransform;
import ai.libs.jaicore.basic.transform.vector.ZTransform;
import java.util.Arrays;
import org.api4.java.common.metric.IDistanceMetric;

public class ShotgunDistance
implements IDistanceMetric {
    private int windowLength;
    private boolean meanNormalization;
    private EuclideanDistance euclideanDistance = new EuclideanDistance();

    public ShotgunDistance(int windowLength, boolean meanNormalization) {
        if (windowLength <= 0) {
            throw new IllegalArgumentException("The window length must not be less or equal to zero.");
        }
        this.windowLength = windowLength;
        this.meanNormalization = meanNormalization;
    }

    @Override
    public double distance(double[] a, double[] b) {
        double totalDistance = 0.0;
        IVectorTransform transform = this.meanNormalization ? new ZTransform() : new NormalizeByStdTransform();
        int numberOfDisjointWindows = a.length / this.windowLength;
        for (int i = 0; i < numberOfDisjointWindows; ++i) {
            int startOfDisjointWindow = i * this.windowLength;
            double[] disjointWindow = Arrays.copyOfRange(a, startOfDisjointWindow, startOfDisjointWindow + this.windowLength);
            disjointWindow = transform.transform(disjointWindow);
            double windowDistance = Double.MAX_VALUE;
            int numberOfSlidingWindows = b.length - this.windowLength + 1;
            for (int j = 0; j < numberOfSlidingWindows; ++j) {
                int startOfSlidingWindow = j;
                double[] slidingWindow = Arrays.copyOfRange(b, startOfSlidingWindow, startOfSlidingWindow + this.windowLength);
                double distanceDisjointSliding = this.euclideanDistance.distance(disjointWindow, slidingWindow = transform.transform(slidingWindow));
                if (!(distanceDisjointSliding < windowDistance)) continue;
                windowDistance = distanceDisjointSliding;
            }
            totalDistance += windowDistance;
        }
        return totalDistance;
    }

    public void setWindowLength(int windowLength) {
        this.windowLength = windowLength;
    }
}

