/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.reconstruction;

import ai.libs.jaicore.basic.reconstruction.ReconstructionPlan;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.api4.java.common.reconstruction.IReconstructible;
import org.api4.java.common.reconstruction.IReconstructionInstruction;
import org.api4.java.common.reconstruction.ReconstructionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconstructionInstruction
implements IReconstructionInstruction {
    private static final long serialVersionUID = -9034513607515486949L;
    private transient Logger logger = LoggerFactory.getLogger(ReconstructionInstruction.class);
    private final String clazzName;
    private final String methodName;
    private final Class<?>[] argumentTypes;
    private final transient Object[] arguments;

    public static boolean isArrayOfPrimitives(Class<?> clazz) {
        return clazz.isArray() && (boolean[].class.isAssignableFrom(clazz) || byte[].class.isAssignableFrom(clazz) || short[].class.isAssignableFrom(clazz) || int[].class.isAssignableFrom(clazz) || long[].class.isAssignableFrom(clazz) || float[].class.isAssignableFrom(clazz) || double[].class.isAssignableFrom(clazz) || char[].class.isAssignableFrom(clazz) || String[].class.isAssignableFrom(clazz));
    }

    @JsonCreator
    public ReconstructionInstruction(@JsonProperty(value="clazzName") String clazzName, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="argumentTypes") Class<?>[] argumentTypes, @JsonProperty(value="arguments") Object[] arguments) {
        Objects.requireNonNull(clazzName);
        Objects.requireNonNull(methodName);
        this.clazzName = clazzName;
        this.methodName = methodName;
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
        int n = argumentTypes.length;
        for (int i = 0; i < n; ++i) {
            boolean isThis;
            Class<?> requiredType;
            block12: {
                requiredType = argumentTypes[i];
                isThis = arguments[i].equals("this");
                this.logger.debug("ARG {}: {} (required type: {})", new Object[]{i, arguments[i], requiredType});
                if (this.doesTypeRequireSerializationDeserialization(requiredType)) {
                    try {
                        if (arguments[i] instanceof String) {
                            arguments[i] = requiredType.cast(((ReconstructionPlan)new ObjectMapper().readValue(arguments[i].toString(), ReconstructionPlan.class)).reconstructObject());
                            break block12;
                        }
                        if (arguments[i] instanceof IReconstructible) {
                            String reconstructionCommand = new ObjectMapper().writeValueAsString((Object)((IReconstructible)arguments[i]).getConstructionPlan());
                            arguments[i] = reconstructionCommand;
                            continue;
                        }
                        throw new IllegalArgumentException("The " + i + "-th argument \"" + arguments[i] + "\" is neither a primitive (it's a " + arguments[i].getClass().getName() + ") nor a class object nor \"this\" and also not a reconstructible object.");
                    }
                    catch (IOException | ReconstructionException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            Class<?> givenType = arguments[i].getClass();
            if (isThis || TypeUtils.isAssignable(givenType, requiredType)) continue;
            if (requiredType != Class.class) {
                throw new IllegalArgumentException("Cannot create instruction. Required type for " + i + "-th argument is " + requiredType + ". But the given object is " + arguments[i] + " (type: " + arguments[i].getClass().getName() + ")");
            }
            if (givenType != String.class) {
                throw new IllegalArgumentException("Cannot create instruction. " + i + "-th argument is required to be a class object (" + argumentTypes[i].getName() + "). The provided object is neither a Class nor a String and hence cannot be derived.");
            }
            try {
                String className = (String)arguments[i];
                if (className.startsWith("class:")) {
                    className = className.substring("class:".length());
                }
                if (className.startsWith("class ")) {
                    className = className.substring("class ".length());
                }
                arguments[i] = Class.forName(className);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot create instruction. " + i + "-th argument is required to be a class object (" + argumentTypes[i].getName() + "). The provided object " + arguments[i] + " is a String that points to a class that does not exist! Cannot derive hence a class object.");
            }
        }
    }

    public ReconstructionInstruction(Method method, Object ... arguments) {
        this.clazzName = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        this.argumentTypes = method.getParameterTypes();
        this.arguments = arguments;
    }

    private boolean doesTypeRequireSerializationDeserialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.equals(String.class)) {
            return false;
        }
        if (ReconstructionInstruction.isArrayOfPrimitives(clazz)) {
            return false;
        }
        if (clazz.equals(Class.class)) {
            return false;
        }
        return !List.class.isAssignableFrom(clazz);
    }

    private Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        Method m;
        String className = this.clazzName;
        if (className.equals("Instances")) {
            className = "weka.core.Instances";
        }
        if ((m = MethodUtils.getMatchingAccessibleMethod(Class.forName(className), (String)this.methodName, (Class[])this.argumentTypes)) == null) {
            throw new NoSuchMethodException("Method " + this.methodName + " for class " + className + " not found!");
        }
        return m;
    }

    private Constructor<?> getConstructor() throws ClassNotFoundException, NoSuchMethodException {
        String className = this.clazzName;
        if (className.equals("Instances")) {
            className = "weka.core.Instances";
        }
        Class<?> clazz = Class.forName(className);
        return this.argumentTypes.length == 0 ? clazz.getConstructor(new Class[0]) : clazz.getConstructor(this.argumentTypes);
    }

    public Object apply(Object object) throws ReconstructionException {
        int n = this.arguments.length;
        Object[] replacedArguments = new Object[n];
        try {
            Method method = this.getMethod();
            for (int i = 0; i < n; ++i) {
                Object val = this.arguments[i];
                if (val instanceof String) {
                    if (val.equals("this")) {
                        replacedArguments[i] = object;
                    } else {
                        String json = (String)val;
                        replacedArguments[i] = ((ReconstructionPlan)new ObjectMapper().readValue(json, ReconstructionPlan.class)).reconstructObject();
                    }
                } else {
                    replacedArguments[i] = this.arguments[i];
                }
                Class<?> type = replacedArguments[i].getClass();
                Class<?> requiredType = method.getParameterTypes()[i];
                if (ClassUtils.isAssignable(type, requiredType, (boolean)true)) continue;
                throw new IllegalStateException("Error in reconstructing object via method " + this.clazzName + "." + this.methodName + ".\nCannot assign parameter of type " + type.getName() + " to required type " + requiredType.getName());
            }
            int k = replacedArguments.length;
            this.logger.debug("{}.{}", (Object)this.getMethod().getDeclaringClass().getName(), (Object)this.getMethod().getName());
            for (int i = 0; i < k; ++i) {
                this.logger.debug("{}: {}: {}", new Object[]{i, replacedArguments[i].getClass().getName(), replacedArguments[i]});
            }
            return method.invoke(null, replacedArguments);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ReconstructionException(e);
        }
    }

    public Object applyToCreate() throws ReconstructionException {
        int m = this.arguments.length;
        if (!this.methodName.equals("__construct")) {
            Method method;
            try {
                method = this.getMethod();
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e1) {
                throw new ReconstructionException(e1);
            }
            this.logger.info("Creating new object via {}.{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            for (int i = 0; i < m; ++i) {
                this.logger.debug("{}:  {}: {}", new Object[]{i, this.arguments[i].getClass().getName(), this.arguments[i]});
            }
            try {
                return method.invoke(null, this.arguments);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                this.logger.error("Error in invoking {}.{} with arguments: {} with class types {}.", new Object[]{this.clazzName, this.methodName, this.arguments, Arrays.stream(this.arguments).map(a -> a.getClass().getName()).collect(Collectors.toList())});
                throw new ReconstructionException(e);
            }
        }
        try {
            Constructor<?> c = this.getConstructor();
            return c.newInstance(this.arguments);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReconstructionException(e);
        }
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

