/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.basic.sets.TupleOfCartesianProductFoundEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDSRelationComputer<T>
extends AAlgorithm<RelationComputationProblem<T>, List<List<T>>> {
    private Logger logger = LoggerFactory.getLogger(LDSRelationComputer.class);
    private final List<List<T>> sets;
    private final int numSets;
    private final Predicate<List<T>> prefixFilter;
    private int computedTuples = 0;
    private final List<T> currentTuple;
    private Queue<Node> open = new PriorityQueue<Node>((n1, n2) -> ((Node)n1).defficiency - ((Node)n2).defficiency);
    private List<Node> recycledNodes = new ArrayList<Node>();
    private int numRecycledNodes;
    private int numCreatedNodes;
    private int reportRate = 1000;

    public LDSRelationComputer(List<Collection<T>> sets) {
        this(new RelationComputationProblem<T>(sets));
    }

    public LDSRelationComputer(RelationComputationProblem<T> problem) {
        super(problem);
        this.sets = new ArrayList<List<T>>();
        for (Collection<T> set : problem.getSets()) {
            this.sets.add(set instanceof List ? (List<Object>)set : new ArrayList<T>(set));
        }
        this.numSets = this.sets.size();
        this.prefixFilter = problem.getPrefixFilter();
        this.currentTuple = new ArrayList<T>();
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.logger.debug("Conducting next algorithm step.");
        switch (this.getState()) {
            case CREATED: {
                this.open.add(new Node(null, -1, 0, 0));
                ++this.numCreatedNodes;
                this.logger.info("Created algorithm for LDS Relation among {} sets with the following cardinalities: {}.", (Object)this.sets.size(), this.sets.stream().map(Collection::size).collect(Collectors.toList()));
                return this.activate();
            }
            case ACTIVE: {
                this.checkAndConductTermination();
                if (this.open.isEmpty()) {
                    this.logger.info("Nothing more to compute, return AlgorithmFinishedEvent.");
                    return this.terminate();
                }
                Node next = null;
                while (!this.open.isEmpty() && (next = this.open.poll()).indexOfSet < this.numSets - 1) {
                    int i = 0;
                    int setIndex = next.indexOfSet + 1;
                    List<T> set = this.sets.get(setIndex);
                    int n = set.size();
                    next.fillTupleArrayWithValues(this.currentTuple);
                    for (int j = 0; j < n; ++j) {
                        this.checkAndConductTermination();
                        long innerTimePoint = System.currentTimeMillis();
                        this.currentTuple.add(set.get(j));
                        assert (System.currentTimeMillis() - innerTimePoint < 5L) : "Copying the " + Node.access$300(next) + "-tuple " + this.currentTuple + " took " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!";
                        innerTimePoint = System.currentTimeMillis();
                        boolean adopt = this.prefixFilter.test(this.currentTuple);
                        this.logger.debug("Prefix filter outputs {} tuple {}", (Object)adopt, this.currentTuple);
                        assert (System.currentTimeMillis() - innerTimePoint < 1000L) : "Testing the " + Node.access$300(next) + "-tuple " + this.currentTuple + " took " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!";
                        if (adopt) {
                            Node newNode;
                            innerTimePoint = System.currentTimeMillis();
                            if (this.recycledNodes.isEmpty()) {
                                newNode = new Node();
                                ++this.numCreatedNodes;
                                assert (System.currentTimeMillis() - innerTimePoint < 5000L) : "Creating a new node took " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!\n" + this.computedTuples + " tuples have been computed already.\nRecycling list contains " + this.recycledNodes.size() + "\nOPEN contains " + this.open.size();
                            } else {
                                newNode = this.recycledNodes.remove(0);
                                assert (System.currentTimeMillis() - innerTimePoint < 10L) : "Retrieving node from recycle list " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!\n" + this.computedTuples + " tuples have been computed already.\nRecycling list contains " + this.recycledNodes.size() + "\nOPEN contains " + this.open.size();
                            }
                            newNode.parent = next;
                            newNode.indexOfSet = next.indexOfSet + 1;
                            newNode.defficiency = next.defficiency + i++;
                            newNode.indexOfValue = j;
                            this.open.add(newNode);
                        }
                        this.currentTuple.remove(setIndex);
                    }
                }
                if (next == null || next.indexOfSet < this.sets.size() - 1) {
                    this.logger.info("No next tuple found, return AlgorithmFinishedEvent.");
                    return this.terminate();
                }
                ++this.computedTuples;
                if (this.computedTuples % this.reportRate == 0) {
                    this.logger.info("Status report: {} have been created.", (Object)this.computedTuples);
                }
                next.fillTupleArrayWithValues(this.currentTuple);
                next.recycle();
                ++this.numRecycledNodes;
                ArrayList<T> tuple = new ArrayList<T>(this.currentTuple);
                assert (this.currentTuple.size() == this.numSets) : "Tuple " + this.currentTuple + " should contain " + this.numSets + " elements but has " + this.currentTuple.size();
                this.logger.debug("Computed tuple {}", tuple);
                return new TupleOfCartesianProductFoundEvent<T>(this, tuple);
            }
        }
        throw new IllegalStateException();
    }

    public List<T> nextTuple() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        while (this.hasNext()) {
            IAlgorithmEvent e = this.nextWithException();
            if (e instanceof AlgorithmFinishedEvent) {
                throw new NoSuchElementException();
            }
            if (e instanceof TupleOfCartesianProductFoundEvent) {
                return ((TupleOfCartesianProductFoundEvent)e).getTuple();
            }
            if (e instanceof AlgorithmInitializedEvent) continue;
            throw new IllegalStateException("Cannot handle event of type " + e.getClass());
        }
        throw new IllegalStateException("No more elements but no AlgorithmFinishedEvent was generated!");
    }

    public List<List<T>> call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        ArrayList<List<T>> product = new ArrayList<List<T>>();
        try {
            List<T> nextTuple;
            while (this.hasNext() && (nextTuple = this.nextTuple()) != null) {
                assert (nextTuple.size() == this.sets.size()) : "The returned tuple " + nextTuple + " does not have " + this.sets.size() + " entries.";
                product.add(nextTuple);
            }
        }
        catch (NoSuchElementException e) {
            this.logger.info("No more solutions exist.");
        }
        this.logger.info("Returning a set of {} tuples.", (Object)product.size());
        return product;
    }

    public int getNumRecycledNodes() {
        return this.numRecycledNodes;
    }

    public int getNumCreatedNodes() {
        return this.numCreatedNodes;
    }

    @Override
    public void setLoggerName(String name) {
        super.setLoggerName(name + "._algorithm");
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger to {}", (Object)name);
        if (this.prefixFilter instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.prefixFilter).setLoggerName(name + ".filter");
        }
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    private class Node {
        private Node parent;
        private int defficiency;
        private int indexOfSet;
        private int indexOfValue;

        public Node() {
        }

        public Node(Node parent, int indexOfSet, int defficiency, int indexInSet) {
            long start = System.currentTimeMillis();
            this.parent = parent;
            this.indexOfSet = indexOfSet;
            this.defficiency = defficiency;
            this.indexOfValue = indexInSet;
            assert (System.currentTimeMillis() - start <= 1L) : "Constructor execution took more than 1ms: " + (System.currentTimeMillis() - start) + "ms";
        }

        public void fillTupleArrayWithValues(List<T> tupleArray) {
            tupleArray.clear();
            this.fillTupleArrayWithValuesRec(tupleArray);
        }

        private void fillTupleArrayWithValuesRec(List<T> tupleArray) {
            if (this.parent == null) {
                return;
            }
            tupleArray.add(0, this.getObject());
            this.parent.fillTupleArrayWithValuesRec(tupleArray);
        }

        T getObject() {
            return ((List)LDSRelationComputer.this.sets.get(this.indexOfSet)).get(this.indexOfValue);
        }

        public void recycle() {
            if (this.indexOfSet >= LDSRelationComputer.this.numSets) {
                LDSRelationComputer.this.recycledNodes.add(this);
            }
        }
    }
}

