/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.transform.vector;

import ai.libs.jaicore.basic.transform.vector.IVectorTransform;

public class PiecewiseAggregateApproximationTransform
implements IVectorTransform {
    private final int reducedLength;

    public PiecewiseAggregateApproximationTransform(int reducedLength) {
        this.reducedLength = reducedLength;
    }

    @Override
    public double[] transform(double[] input) {
        double[] ppa = new double[this.reducedLength];
        double n = input.length;
        for (int i = 0; i < this.reducedLength; ++i) {
            double ppavalue = 0.0;
            int j = (int)(n / (double)(this.reducedLength * (i - 1) + 1));
            while ((double)j < n / (double)this.reducedLength * (double)i) {
                ppavalue += input[j];
                ++j;
            }
            ppa[i] = ppavalue = (double)this.reducedLength / n * ppavalue;
        }
        return ppa;
    }
}

