/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.concurrent;

import ai.libs.jaicore.concurrent.TrackableTimer;
import ai.libs.jaicore.concurrent.TrackableTimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTimer
extends TrackableTimer {
    private static final Logger logger = LoggerFactory.getLogger(GlobalTimer.class);
    private static final GlobalTimer instance = new GlobalTimer();

    private GlobalTimer() {
        super("Global Timer", true);
        this.schedule(new TrackableTimerTask(){

            @Override
            public void exec() {
                Thread timerThread = Thread.currentThread();
                logger.info("Changing global timer thread {} priority from {} to {}", new Object[]{timerThread, timerThread.getPriority(), 10});
                timerThread.setPriority(10);
                logger.info("Priority of global timer thread {} is now {}", (Object)timerThread, (Object)timerThread.getPriority());
            }
        }, 0L);
    }

    public static GlobalTimer getInstance() {
        return instance;
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException("The TimeoutTimer must not be canceled manually!");
    }
}

