/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.concurrent;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.concurrent.TrackableTimerTask;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.api4.java.common.control.ICancelable;

public class TrackableTimer
extends Timer
implements ICancelable {
    private static final String MSG_ERROR = "TimerTasks are not trackable. Please create a TrackableTimerTask first and submit that one.";
    private final Queue<TrackableTimerTask> scheduledSingleInvocationTasks = new LinkedList<TrackableTimerTask>();
    private final Queue<TrackableTimerTask> scheduledReocurringTasks = new LinkedList<TrackableTimerTask>();
    private final Map<TimerTask, Long> ratesOfReocurringTasks = new HashMap<TimerTask, Long>();
    private boolean canceled;

    public TrackableTimer() {
    }

    public TrackableTimer(boolean isDaemon) {
        super(isDaemon);
    }

    public TrackableTimer(String name, boolean isDaemon) {
        super(name, isDaemon);
    }

    public TrackableTimer(String name) {
        super(name);
    }

    @Override
    @Deprecated
    public void schedule(TimerTask task, Date time) {
        throw new UnsupportedOperationException(MSG_ERROR);
    }

    @Override
    @Deprecated
    public void schedule(TimerTask task, Date time, long period) {
        throw new UnsupportedOperationException(MSG_ERROR);
    }

    @Override
    @Deprecated
    public void schedule(TimerTask task, long delay) {
        throw new UnsupportedOperationException(MSG_ERROR);
    }

    @Override
    @Deprecated
    public void schedule(TimerTask task, long delay, long period) {
        throw new UnsupportedOperationException(MSG_ERROR);
    }

    @Override
    @Deprecated
    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        throw new UnsupportedOperationException(MSG_ERROR);
    }

    @Override
    @Deprecated
    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        throw new UnsupportedOperationException(MSG_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TrackableTimerTask task, Date time) {
        super.schedule((TimerTask)task, time);
        Queue<TrackableTimerTask> queue = this.scheduledSingleInvocationTasks;
        synchronized (queue) {
            this.scheduledSingleInvocationTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TrackableTimerTask task, Date time, long period) {
        super.schedule((TimerTask)task, time, period);
        Queue<TrackableTimerTask> queue = this.scheduledReocurringTasks;
        synchronized (queue) {
            this.scheduledReocurringTasks.add(task);
        }
        this.ratesOfReocurringTasks.put(task, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TrackableTimerTask task, long delay) {
        super.schedule((TimerTask)task, delay);
        Queue<TrackableTimerTask> queue = this.scheduledSingleInvocationTasks;
        synchronized (queue) {
            this.scheduledSingleInvocationTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TrackableTimerTask task, long delay, long period) {
        super.schedule((TimerTask)task, delay, period);
        Queue<TrackableTimerTask> queue = this.scheduledReocurringTasks;
        synchronized (queue) {
            this.scheduledReocurringTasks.add(task);
        }
        this.ratesOfReocurringTasks.put(task, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAtFixedRate(TrackableTimerTask task, Date firstTime, long period) {
        super.scheduleAtFixedRate((TimerTask)task, firstTime, period);
        Queue<TrackableTimerTask> queue = this.scheduledReocurringTasks;
        synchronized (queue) {
            this.scheduledReocurringTasks.add(task);
        }
        this.ratesOfReocurringTasks.put(task, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAtFixedRate(TrackableTimerTask task, long delay, long period) {
        super.scheduleAtFixedRate((TimerTask)task, delay, period);
        Queue<TrackableTimerTask> queue = this.scheduledReocurringTasks;
        synchronized (queue) {
            this.scheduledReocurringTasks.add(task);
        }
        this.ratesOfReocurringTasks.put(task, period);
    }

    public boolean hasTaskBeenExecutedInPast(TrackableTimerTask task) {
        return task.hasBeenExecuted();
    }

    public boolean willTaskBeExecutedInFuture(TrackableTimerTask task) {
        if (this.canceled || task.isCanceled()) {
            return false;
        }
        if (this.scheduledSingleInvocationTasks.contains(task)) {
            return !this.hasTaskBeenExecutedInPast(task);
        }
        return this.scheduledReocurringTasks.contains(task);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        super.cancel();
    }

    public boolean isCanceld() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TrackableTimerTask> getActiveTasks() {
        Queue<TrackableTimerTask> queue = this.scheduledSingleInvocationTasks;
        synchronized (queue) {
            Queue<TrackableTimerTask> queue2 = this.scheduledReocurringTasks;
            synchronized (queue2) {
                return SetUtil.union(this.scheduledSingleInvocationTasks, this.scheduledReocurringTasks).stream().filter(this::willTaskBeExecutedInFuture).collect(Collectors.toList());
            }
        }
    }

    public int getNumberOfActiveTasks() {
        return this.getActiveTasks().size();
    }

    public boolean hasOpenTasks() {
        return !this.getActiveTasks().isEmpty();
    }
}

