/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.db;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.db.sql.SQLAdapter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.api4.java.datastructure.kvstore.IKVStore;

public class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static void createTableFromResult(SQLAdapter adapter, String sqlQuery, List<String> params, String tableName, List<String> fieldnames, Map<String, Pair<Class<?>, Function<IKVStore, Object>>> transformation) throws SQLException {
        if (fieldnames.size() != transformation.size() || !fieldnames.containsAll(transformation.keySet())) {
            throw new IllegalArgumentException("Fieldnames is " + fieldnames + " but keys in transformation table are " + transformation.keySet());
        }
        HashMap<String, String> typeMap = new HashMap<String, String>();
        ArrayList<String> fields = new ArrayList<String>();
        for (Map.Entry<String, Pair<Class<?>, Function<IKVStore, Object>>> key : transformation.entrySet()) {
            fields.add(key.getKey());
            String type = null;
            switch (key.getValue().getX().getName()) {
                case "java.lang.Double": {
                    type = "DOUBLE";
                    break;
                }
                case "java.lang.String": {
                    type = "TEXT";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Target class " + key.getValue().getX().getName() + " not supported.");
                }
            }
            typeMap.put(key.getKey(), type);
        }
        typeMap.put("c_id", "INT(8)");
        adapter.createTable(tableName, "c_id", fields, typeMap, Arrays.asList(new String[0]));
        int pageSize = 100;
        Set<String> keys = transformation.keySet();
        boolean insertedLine = true;
        int page = 0;
        while (insertedLine) {
            String qry = sqlQuery + " LIMIT " + pageSize * page + ", " + pageSize;
            Iterator<IKVStore> rowIterator = adapter.getResultIteratorOfQuery(qry, params);
            insertedLine = false;
            while (rowIterator.hasNext()) {
                IKVStore row = rowIterator.next();
                HashMap<String, Object> tRow = new HashMap<String, Object>();
                for (String key : keys) {
                    tRow.put(key, transformation.get(key).getY().apply(row));
                }
                adapter.insert(tableName, tRow);
                insertedLine = true;
            }
            ++page;
        }
    }
}

