/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.db.sql;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.db.sql.ISQLQueryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MySQLQueryBuilder
implements ISQLQueryBuilder {
    private static final String DB_DRIVER = "mysql";
    private static final String KEY_EQUALS_VALUE_TO_BE_SET = " = (?)";
    private static final String STR_SPACE_AND = " AND ";
    private static final String STR_SPACE_WHERE = " WHERE ";

    @Override
    public Pair<String, List<Object>> buildInsertStatement(String table, Map<String, ? extends Object> map) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (sb1.length() != 0) {
                sb1.append(", ");
                sb2.append(", ");
            }
            sb1.append(entry.getKey());
            sb2.append("?");
            values.add(entry.getValue());
        }
        String statement = "INSERT INTO " + table + " (" + sb1.toString() + ") VALUES (" + sb2.toString() + ")";
        return new Pair<String, List<Object>>(statement, values);
    }

    @Override
    public String buildInsertSQLCommand(String table, Map<String, ? extends Object> map) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (sb1.length() != 0) {
                sb1.append(", ");
                sb2.append(", ");
            }
            sb1.append(entry.getKey());
            sb2.append("\"" + entry.getValue().toString().replace("\"", "\\\"") + "\"");
        }
        return "INSERT INTO " + table + " (" + sb1.toString() + ") VALUES (" + sb2.toString() + ")";
    }

    @Override
    public String buildMultiInsertSQLCommand(String table, List<String> keys, List<List<?>> datarows) {
        StringBuilder sbMain = new StringBuilder();
        StringBuilder sbKeys = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        sbMain.append("INSERT INTO `");
        sbMain.append(table);
        sbMain.append("` (");
        for (String string : keys) {
            if (sbKeys.length() != 0) {
                sbKeys.append(", ");
            }
            sbKeys.append(string);
        }
        sbMain.append((CharSequence)sbKeys);
        sbMain.append(") VALUES\n");
        for (List list : datarows) {
            if (list.contains(null)) {
                throw new IllegalArgumentException("Row " + list + " contains null element!");
            }
            if (sbValues.length() > 0) {
                sbValues.append(",\n ");
            }
            sbValues.append("(");
            sbValues.append(list.stream().map(s -> "\"" + s.toString().replace("\"", "\\\"") + "\"").collect(Collectors.joining(", ")));
            sbValues.append(")");
        }
        sbMain.append((CharSequence)sbValues);
        return sbMain.toString();
    }

    @Override
    public String parseSQLCommand(String sql, List<?> values) {
        Pattern p = Pattern.compile("\\?");
        Matcher m = p.matcher(sql);
        String modifiedSql = sql;
        int index = 0;
        while (m.find()) {
            modifiedSql = modifiedSql.replaceFirst("\\?", values.get(index).toString());
            ++index;
        }
        return modifiedSql;
    }

    @Override
    public String buildSelectSQLCommand(String table, Map<String, String> conditions) {
        StringBuilder conditionSB = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : conditions.entrySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(STR_SPACE_AND);
            } else {
                conditionSB.append(STR_SPACE_WHERE);
            }
            conditionSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
            values.add(entry.getValue());
        }
        return this.parseSQLCommand("SELECT * FROM `" + table + "`" + conditionSB.toString(), values);
    }
}

