/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.db.sql;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.db.IDatabaseAdapter;
import ai.libs.jaicore.db.IDatabaseConfig;
import ai.libs.jaicore.db.sql.ISQLQueryBuilder;
import ai.libs.jaicore.db.sql.MySQLQueryBuilder;
import ai.libs.jaicore.db.sql.ResultSetToKVStoreSerializer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLAdapter
implements IDatabaseAdapter {
    private transient Logger logger = LoggerFactory.getLogger(SQLAdapter.class);
    private static final String DB_DRIVER = "mysql";
    private static final String KEY_EQUALS_VALUE_TO_BE_SET = " = (?)";
    private static final String STR_SPACE_AND = " AND ";
    private static final String STR_SPACE_WHERE = " WHERE ";
    private final String driver;
    private final String host;
    private final String user;
    private final String password;
    private final String database;
    private final boolean ssl;
    private final Properties connectionProperties;
    private final ISQLQueryBuilder queryBuilder = new MySQLQueryBuilder();
    private transient Connection connect;
    private long timestampOfLastAction = Long.MIN_VALUE;

    public SQLAdapter(IDatabaseConfig config) {
        this(DB_DRIVER, config.getDBHost(), config.getDBUsername(), config.getDBPassword(), config.getDBDatabaseName(), new Properties(), config.getDBSSL());
    }

    public SQLAdapter(String host, String user, String password, String database, boolean ssl) {
        this(DB_DRIVER, host, user, password, database, new Properties(), ssl);
    }

    public SQLAdapter(String host, String user, String password, String database) {
        this(DB_DRIVER, host, user, password, database, new Properties());
    }

    public SQLAdapter(String driver, String host, String user, String password, String database, Properties connectionProperties) {
        this(driver, host, user, password, database, connectionProperties, true);
    }

    public SQLAdapter(String driver, String host, String user, String password, String database, Properties connectionProperties, boolean ssl) {
        this.ssl = ssl;
        this.driver = driver;
        this.host = host;
        this.user = user;
        this.password = password;
        this.database = database;
        this.connectionProperties = connectionProperties;
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
    }

    private void connect() throws SQLException {
        int tries = 0;
        while (true) {
            try {
                Properties connectionProps = new Properties(this.connectionProperties);
                connectionProps.put("user", this.user);
                connectionProps.put("password", this.password);
                String connectionString = "jdbc:" + this.driver + "://" + this.host + "/" + this.database + (this.ssl ? "?verifyServerCertificate=false&requireSSL=true&useSSL=true" : "");
                this.connect = DriverManager.getConnection(connectionString, connectionProps);
                return;
            }
            catch (SQLException e) {
                block5: {
                    this.logger.error("Connection to server {} failed with JDBC driver {} (attempt {} of 3), waiting 3 seconds before trying again.", new Object[]{this.host, this.driver, ++tries, e});
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        this.logger.error("SQLAdapter got interrupted while trying to establish a connection to the database. NOTE: This will trigger an immediate shutdown as no sql connection could be established. Reason for the interrupt was:", (Throwable)e1);
                        break block5;
                    }
                    if (tries < 3) continue;
                }
                this.logger.error("Quitting execution as no database connection could be established");
                System.exit(1);
                return;
            }
            break;
        }
    }

    public PreparedStatement getPreparedStatement(String query) throws SQLException {
        this.checkConnection();
        return this.connect.prepareStatement(query);
    }

    @Override
    public synchronized void checkConnection() throws SQLException {
        int renewAfterSeconds = 300;
        if (this.timestampOfLastAction + (long)(renewAfterSeconds * 1000) < System.currentTimeMillis()) {
            this.close();
            this.connect();
        }
        this.timestampOfLastAction = System.currentTimeMillis();
    }

    @Override
    public List<IKVStore> getRowsOfTable(String table) throws SQLException {
        this.logger.info("Fetching complete table {}", (Object)table);
        return this.getRowsOfTable(table, new HashMap<String, String>());
    }

    @Override
    public List<IKVStore> getRowsOfTable(String table, Map<String, String> conditions) throws SQLException {
        return this.getResultsOfQuery(this.queryBuilder.buildSelectSQLCommand(table, conditions));
    }

    public Iterator<IKVStore> getRowIteratorOfTable(String table) throws SQLException {
        return this.getRowIteratorOfTable(table, new HashMap<String, String>());
    }

    public Iterator<IKVStore> getRowIteratorOfTable(String table, Map<String, String> conditions) throws SQLException {
        StringBuilder conditionSB = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : conditions.entrySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(STR_SPACE_AND);
            } else {
                conditionSB.append(STR_SPACE_WHERE);
            }
            conditionSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
            values.add(entry.getValue());
        }
        return this.getResultIteratorOfQuery("SELECT * FROM `" + table + "`" + conditionSB.toString(), values);
    }

    @Override
    public List<IKVStore> getResultsOfQuery(String query) throws SQLException {
        return this.getResultsOfQuery(query, new ArrayList<String>());
    }

    @Override
    public List<IKVStore> getResultsOfQuery(String query, String[] values) throws SQLException {
        return this.getResultsOfQuery(query, Arrays.asList(values));
    }

    @Override
    public List<IKVStore> getResultsOfQuery(String query, List<String> values) throws SQLException {
        this.checkConnection();
        this.logger.info("Conducting query {} with values {}", (Object)query, values);
        try (PreparedStatement statement = this.connect.prepareStatement(query);){
            for (int i = 1; i <= values.size(); ++i) {
                statement.setString(i, values.get(i - 1));
            }
            List<IKVStore> list = new ResultSetToKVStoreSerializer().serialize(statement.executeQuery());
            return list;
        }
    }

    public Iterator<IKVStore> getResultIteratorOfQuery(String query, List<String> values) throws SQLException {
        this.checkConnection();
        boolean autoCommit = this.connect.getAutoCommit();
        this.connect.setAutoCommit(false);
        this.logger.info("Conducting query {} with values {}", (Object)query, values);
        PreparedStatement statement = this.connect.prepareStatement(query, 1003, 1007);
        statement.setFetchSize(100);
        for (int i = 1; i <= values.size(); ++i) {
            statement.setString(i, values.get(i - 1));
        }
        Iterator<IKVStore> iterator = new ResultSetToKVStoreSerializer().getSerializationIterator(statement.executeQuery());
        this.connect.setAutoCommit(autoCommit);
        return iterator;
    }

    @Override
    public int[] insert(String sql, String[] values) throws SQLException {
        return this.insert(sql, Arrays.asList(values));
    }

    @Override
    public int[] insert(String sql, List<? extends Object> values) throws SQLException {
        this.checkConnection();
        try (PreparedStatement stmt = this.connect.prepareStatement(sql, 1);){
            for (int i = 1; i <= values.size(); ++i) {
                this.setValue(stmt, i, values.get(i - 1));
            }
            stmt.executeUpdate();
            LinkedList<Integer> generatedKeys = new LinkedList<Integer>();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                while (rs.next()) {
                    generatedKeys.add(rs.getInt(1));
                }
            }
            int[] nArray = generatedKeys.stream().mapToInt(x -> x).toArray();
            return nArray;
        }
    }

    @Override
    public int[] insert(String table, Map<String, ? extends Object> map) throws SQLException {
        Pair<String, List<Object>> insertStatement = this.queryBuilder.buildInsertStatement(table, map);
        return this.insert(insertStatement.getX(), insertStatement.getY());
    }

    @Override
    public int[] insertMultiple(String table, List<String> keys, List<List<? extends Object>> datarows) throws SQLException {
        return this.insertMultiple(table, keys, datarows, 10000);
    }

    @Override
    public int[] insertMultiple(String table, List<String> keys, List<List<? extends Object>> datarows, int chunkSize) throws SQLException {
        int n = datarows.size();
        ArrayList<Integer> ids = new ArrayList<Integer>(n);
        try (Statement stmt = this.connect.createStatement();){
            int i = 0;
            while ((double)i < Math.ceil((double)n * 1.0 / (double)chunkSize)) {
                int startIndex = i * chunkSize;
                int endIndex = Math.min((i + 1) * chunkSize, n);
                String sql = this.queryBuilder.buildMultiInsertSQLCommand(table, keys, datarows.subList(startIndex, endIndex));
                this.logger.debug("Created SQL for {} entries", (Object)(endIndex - startIndex));
                this.logger.trace("Adding sql statement {} to batch", (Object)sql);
                stmt.addBatch(sql);
                ++i;
            }
            this.logger.debug("Start batch execution.");
            stmt.executeBatch();
            this.logger.debug("Finished batch execution.");
            try (ResultSet rs = stmt.getGeneratedKeys();){
                while (rs.next()) {
                    ids.add(rs.getInt(1));
                }
            }
            int[] nArray = ids.stream().mapToInt(x -> x).toArray();
            return nArray;
        }
    }

    @Override
    public int update(String sql) throws SQLException {
        return this.update(sql, new ArrayList());
    }

    @Override
    public int update(String sql, String[] values) throws SQLException {
        return this.update(sql, Arrays.asList(values));
    }

    @Override
    public int update(String sql, List<? extends Object> values) throws SQLException {
        this.checkConnection();
        try (PreparedStatement stmt = this.connect.prepareStatement(sql);){
            for (int i = 1; i <= values.size(); ++i) {
                stmt.setString(i, values.get(i - 1).toString());
            }
            int n = stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public int update(String table, Map<String, ? extends Object> updateValues, Map<String, ? extends Object> conditions) throws SQLException {
        this.checkConnection();
        StringBuilder updateSB = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, ? extends Object> entry : updateValues.entrySet()) {
            if (updateSB.length() > 0) {
                updateSB.append(", ");
            }
            updateSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
            values.add(entry.getValue());
        }
        StringBuilder conditionSB = new StringBuilder();
        for (Map.Entry<String, ? extends Object> entry : conditions.entrySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(STR_SPACE_AND);
            }
            if (entry.getValue() != null) {
                conditionSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
                values.add(entry.getValue());
                continue;
            }
            conditionSB.append(entry.getKey());
            conditionSB.append(" IS NULL");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(table);
        stringBuilder.append(" SET ");
        stringBuilder.append(updateSB.toString());
        stringBuilder.append(STR_SPACE_WHERE);
        stringBuilder.append(conditionSB.toString());
        try (PreparedStatement preparedStatement = this.connect.prepareStatement(stringBuilder.toString());){
            for (int i = 1; i <= values.size(); ++i) {
                this.setValue(preparedStatement, i, values.get(i - 1));
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueriesAtomically(List<PreparedStatement> queries) throws SQLException {
        this.checkConnection();
        this.connect.setAutoCommit(false);
        try {
            for (PreparedStatement query : queries) {
                query.execute();
            }
            this.connect.commit();
        }
        catch (SQLException e) {
            this.logger.error("Transaction is being rolled back.", (Throwable)e);
            try {
                this.connect.rollback();
            }
            catch (SQLException e1) {
                this.logger.error("Could not rollback the connection", (Throwable)e1);
            }
        }
        finally {
            for (PreparedStatement query : queries) {
                if (query == null) continue;
                query.close();
            }
            this.connect.setAutoCommit(true);
        }
    }

    @Override
    public List<IKVStore> query(String sqlStatement) throws SQLException, IOException {
        this.checkConnection();
        try (PreparedStatement ps = this.connect.prepareStatement(sqlStatement);){
            boolean success = ps.execute();
            if (success) {
                List<IKVStore> list = new ResultSetToKVStoreSerializer().serialize(ps.getResultSet());
                return list;
            }
            LinkedList<IKVStore> linkedList = new LinkedList<IKVStore>();
            return linkedList;
        }
    }

    private void setValue(PreparedStatement stmt, int index, Object val) throws SQLException {
        if (val instanceof Integer) {
            stmt.setInt(index, (Integer)val);
        } else if (val instanceof Long) {
            stmt.setLong(index, (Long)val);
        } else if (val instanceof Number) {
            stmt.setDouble(index, (Double)val);
        } else if (val instanceof String) {
            stmt.setString(index, (String)val);
        } else {
            stmt.setObject(index, val);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connect != null) {
                this.connect.close();
            }
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while closing the database connection.", (Throwable)e);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public void createTable(String tablename, String nameOfPrimaryField, Collection<String> fieldnames, Map<String, String> types, Collection<String> keys) throws SQLException {
        this.checkConnection();
        Objects.requireNonNull(this.connect);
        StringBuilder sqlMainTable = new StringBuilder();
        StringBuilder keyFieldsSB = new StringBuilder();
        sqlMainTable.append("CREATE TABLE IF NOT EXISTS `" + tablename + "` (");
        sqlMainTable.append("`" + nameOfPrimaryField + "` " + types.get(nameOfPrimaryField) + " NOT NULL AUTO_INCREMENT,");
        for (String key : fieldnames) {
            sqlMainTable.append("`" + key + "` " + types.get(key) + " NOT NULL,");
            keyFieldsSB.append("`" + key + "`,");
        }
        sqlMainTable.append("PRIMARY KEY (`" + nameOfPrimaryField + "`)");
        sqlMainTable.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
        try (Statement stmt = this.connect.createStatement();){
            stmt.execute(sqlMainTable.toString());
        }
    }

    private class ShutdownThread
    extends Thread {
        private SQLAdapter adapter;

        public ShutdownThread(SQLAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void run() {
            this.adapter.close();
        }
    }
}

