/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.db.sql.rest;

import ai.libs.jaicore.basic.kvstore.KVStoreUtil;
import ai.libs.jaicore.db.IDatabaseAdapter;
import ai.libs.jaicore.db.sql.ISQLQueryBuilder;
import ai.libs.jaicore.db.sql.MySQLQueryBuilder;
import ai.libs.jaicore.db.sql.rest.IRestDatabaseConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSqlAdapter
implements IDatabaseAdapter {
    private final transient ISQLQueryBuilder queryBuilder = new MySQLQueryBuilder();
    private transient Logger logger = LoggerFactory.getLogger(RestSqlAdapter.class);
    private final String host;
    private final String token;
    private final String querySuffix;
    private final String selectSuffix;
    private final String insertSuffix;
    private final String updateSuffix;

    public RestSqlAdapter(IRestDatabaseConfig config) {
        this.host = config.getHost();
        this.token = config.getToken();
        this.querySuffix = config.getQuerySuffix();
        this.selectSuffix = config.getSelectSuffix();
        this.updateSuffix = config.getUpdateSuffix();
        this.insertSuffix = config.getInsertSuffix();
        Objects.requireNonNull(this.host);
        Objects.requireNonNull(this.insertSuffix);
        Objects.requireNonNull(this.updateSuffix);
        Objects.requireNonNull(this.selectSuffix);
        Objects.requireNonNull(this.querySuffix);
    }

    public List<IKVStore> select(String query) throws SQLException {
        this.logger.info("Sending query {}", (Object)query);
        JsonNode res = this.executeRESTCall(this.host + this.selectSuffix, query);
        this.logger.info("Received result as JSON node: {}.", (Object)res);
        return KVStoreUtil.readFromJson(res);
    }

    @Override
    public int[] insert(String table, Map<String, ? extends Object> values) throws SQLException {
        return this.insert(this.queryBuilder.buildInsertSQLCommand(table, values));
    }

    public int[] insertMultiple(String tablename, List<String> keys, List<List<?>> values) throws SQLException {
        return this.insert(this.queryBuilder.buildMultiInsertSQLCommand(tablename, keys, values));
    }

    public int[] insert(String query) throws SQLException {
        JsonNode res = this.executeRESTCall(this.host + this.insertSuffix, query);
        if (res instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)res;
            return IntStream.range(0, array.size()).map(i -> array.get(i).asInt()).toArray();
        }
        throw new IllegalStateException("Cannot parse result for insert query");
    }

    @Override
    public int update(String query) throws SQLException {
        JsonNode res = this.executeRESTCall(this.host + this.updateSuffix, query);
        return res.asInt();
    }

    @Override
    public List<IKVStore> query(String query) throws SQLException {
        JsonNode res = this.executeRESTCall(this.host + this.querySuffix, query);
        return KVStoreUtil.readFromJson(res);
    }

    public JsonNode executeRESTCall(String URL2, String query) throws SQLException {
        JsonNode jsonNode;
        block8: {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            try {
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode root = mapper.createObjectNode();
                root.set("token", (JsonNode)root.textNode(this.token));
                root.set("query", (JsonNode)root.textNode(query));
                String jsonPayload = mapper.writeValueAsString((Object)root);
                StringEntity requestEntity = new StringEntity(jsonPayload, ContentType.APPLICATION_JSON);
                HttpPost post = new HttpPost(URL2);
                post.setEntity((HttpEntity)requestEntity);
                CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                jsonNode = mapper.readTree(response.getEntity().getContent());
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UnsupportedOperationException e) {
                    throw new SQLException(e);
                }
            }
            client.close();
        }
        return jsonNode;
    }

    @Override
    public int update(String tablename, Map<String, ? extends Object> valuesToWrite, Map<String, ? extends Object> where) throws SQLException {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append("UPDATE " + tablename + " SET ");
        queryStringBuilder.append(valuesToWrite.entrySet().stream().map(e -> (String)e.getKey() + "='" + e.getValue() + "'").collect(Collectors.joining(",")));
        if (!where.isEmpty()) {
            queryStringBuilder.append(" WHERE ");
            queryStringBuilder.append(where.entrySet().stream().map(e -> RestSqlAdapter.whereClauseElement((String)e.getKey(), e.getValue() != null ? e.getValue().toString() : null)).collect(Collectors.joining(" AND ")));
        }
        return this.update(queryStringBuilder.toString());
    }

    public static String whereClauseElement(String key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        if (value == null || value.equals("null")) {
            sb.append(" IS NULL");
        } else {
            sb.append("='");
            sb.append(value);
            sb.append("'");
        }
        return sb.toString();
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public void checkConnection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createTable(String tablename, String nameOfPrimaryField, Collection<String> fieldnames, Map<String, String> types, Collection<String> keys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IKVStore> getRowsOfTable(String table, Map<String, String> conditions) throws SQLException {
        return this.query(this.queryBuilder.buildSelectSQLCommand(table, conditions));
    }

    @Override
    public List<IKVStore> getResultsOfQuery(String query, List<String> values) throws SQLException {
        if (values.isEmpty()) {
            return this.select(query);
        }
        throw new UnsupportedOperationException("Cannot cope with prepared statements and values to set.");
    }

    @Override
    public int[] insert(String sql, List<? extends Object> values) throws SQLException {
        return this.insert(this.queryBuilder.parseSQLCommand(sql, values));
    }

    @Override
    public int[] insertMultiple(String table, List<String> keys, List<List<? extends Object>> datarows, int chunkSize) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int update(String sql, List<? extends Object> values) throws SQLException {
        return this.update(this.queryBuilder.parseSQLCommand(sql, values));
    }

    @Override
    public void executeQueriesAtomically(List<PreparedStatement> queries) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

