/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graph;

import java.util.Collections;
import java.util.List;
import org.api4.java.datastructure.graph.ILabeledPath;

public class ReadOnlyPathAccessor<N, A>
implements ILabeledPath<N, A> {
    private final ILabeledPath<N, A> path;

    public ReadOnlyPathAccessor(ILabeledPath<N, A> path) {
        this.path = path;
    }

    public ILabeledPath<N, A> getUnmodifiableAccessor() {
        return this;
    }

    public N getRoot() {
        return (N)this.path.getRoot();
    }

    public N getHead() {
        return (N)this.path.getHead();
    }

    public N getParentOfHead() {
        return (N)this.path.getParentOfHead();
    }

    public void extend(N newHead, A arcToNewHead) {
        throw new UnsupportedOperationException("This is a read-only path.");
    }

    public void cutHead() {
        throw new UnsupportedOperationException("This is a read-only path.");
    }

    public ILabeledPath<N, A> getPathToParentOfHead() {
        return this.path.getPathToParentOfHead();
    }

    public ILabeledPath<N, A> getPathFromChildOfRoot() {
        return this.path.getPathFromChildOfRoot();
    }

    public List<N> getNodes() {
        return Collections.unmodifiableList(this.path.getNodes());
    }

    public boolean isPoint() {
        return this.path.isPoint();
    }

    public int getNumberOfNodes() {
        return this.path.getNumberOfNodes();
    }

    public List<A> getArcs() {
        return Collections.unmodifiableList(this.path.getArcs());
    }

    public A getInArc(N node) {
        return (A)this.path.getInArc(node);
    }

    public A getOutArc(N node) {
        return (A)this.path.getOutArc(node);
    }

    public boolean containsNode(N node) {
        return this.path.containsNode(node);
    }
}

