/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.enhancedttsp;

import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPSolutionEvaluator;
import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPState;
import ai.libs.jaicore.problems.enhancedttsp.Location;
import it.unimi.dsi.fastutil.shorts.Short2DoubleArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2DoubleMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedTTSP {
    private final short startLocation;
    private final int numberOfConsideredHours;
    private final List<Location> locations;
    private final Short2DoubleMap xCoords = new Short2DoubleArrayMap();
    private final Short2DoubleMap yCoords = new Short2DoubleArrayMap();
    private final List<Boolean> blockedHours;
    private final double hourOfDeparture;
    private final double durationOfShortBreak;
    private final double durationOfLongBreak;
    private final double maxConsecutiveDrivingTime;
    private final double maxDrivingTimeBetweenLongBreaks;
    private final ShortList possibleDestinations;
    private final EnhancedTTSPSolutionEvaluator solutionEvaluator;
    private Logger logger = LoggerFactory.getLogger(EnhancedTTSP.class);

    public EnhancedTTSP(List<Location> locations, short startLocation, List<Boolean> blockedHours, double hourOfDeparture, double maxConsecutiveDrivingTime, double durationOfShortBreak, double durationOfLongBreak) {
        this.startLocation = startLocation;
        this.numberOfConsideredHours = blockedHours.size();
        this.locations = locations;
        for (Location l : locations) {
            this.xCoords.put(l.getId(), l.getX());
            this.yCoords.put(l.getId(), l.getY());
        }
        this.blockedHours = blockedHours;
        this.hourOfDeparture = hourOfDeparture;
        this.durationOfShortBreak = durationOfShortBreak;
        this.durationOfLongBreak = durationOfLongBreak;
        this.maxConsecutiveDrivingTime = maxConsecutiveDrivingTime;
        this.maxDrivingTimeBetweenLongBreaks = 24.0 - durationOfLongBreak;
        this.possibleDestinations = new ShortArrayList((Collection)locations.stream().map(Location::getId).sorted().collect(Collectors.toList()));
        this.solutionEvaluator = new EnhancedTTSPSolutionEvaluator(this);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public short getStartLocation() {
        return this.startLocation;
    }

    public int getNumberOfConsideredHours() {
        return this.numberOfConsideredHours;
    }

    public List<Boolean> getBlockedHours() {
        return this.blockedHours;
    }

    public double getHourOfDeparture() {
        return this.hourOfDeparture;
    }

    public double getDurationOfShortBreak() {
        return this.durationOfShortBreak;
    }

    public double getDurationOfLongBreak() {
        return this.durationOfLongBreak;
    }

    public double getMaxConsecutiveDrivingTime() {
        return this.maxConsecutiveDrivingTime;
    }

    public double getMaxDrivingTimeBetweenLongBreaks() {
        return this.maxDrivingTimeBetweenLongBreaks;
    }

    public ShortList getPossibleDestinations() {
        return this.possibleDestinations;
    }

    public EnhancedTTSPState getInitalState() {
        return new EnhancedTTSPState(null, this.startLocation, this.hourOfDeparture, 0.0, 0.0);
    }

    public EnhancedTTSPState computeSuccessorState(EnhancedTTSPState n, short destination) {
        this.logger.info("Generating successor for node {} to go to destination {}", (Object)n, (Object)destination);
        if (n.getCurLocation() == destination) {
            throw new IllegalArgumentException("It is forbidden to ask for the successor to the current position as a destination!");
        }
        short curLocation = n.getCurLocation();
        double curTime = n.getTime();
        double timeSinceLastShortBreak = n.getTimeTraveledSinceLastShortBreak();
        double timeSinceLastLongBreak = n.getTimeTraveledSinceLastLongBreak();
        double minTravelTime = Math.sqrt(Math.pow(this.xCoords.get(curLocation) - this.xCoords.get(destination), 2.0) + Math.pow(this.yCoords.get(curLocation) - this.yCoords.get(destination), 2.0));
        this.logger.info("Simulating the ride from {} to {}, which minimally takes {}. We are departing at {}", new Object[]{curLocation, destination, minTravelTime, curTime});
        double timeToNextShortBreak = this.getTimeToNextShortBreak(Math.min(timeSinceLastShortBreak, timeSinceLastLongBreak));
        double timeToNextLongBreak = this.getTimeToNextLongBreak(curTime, timeSinceLastLongBreak);
        this.logger.info("Next short break will be in {}h", (Object)timeToNextShortBreak);
        this.logger.info("Next long break will be in {}h", (Object)timeToNextLongBreak);
        boolean arrived = false;
        double shareOfTheTripDone = 0.0;
        double timeOfArrival = -1.0;
        while (!arrived) {
            boolean doLongBreak;
            double permittedTimeToTravel = Math.min(timeToNextShortBreak, timeToNextLongBreak);
            double travelTimeWithoutBreak = this.getActualDrivingTimeWithoutBreak(minTravelTime, curTime, shareOfTheTripDone);
            assert (timeToNextShortBreak >= 0.0) : "Time to next short break cannot be negative!";
            assert (timeToNextLongBreak >= 0.0) : "Time to next long break cannot be negative!";
            assert (travelTimeWithoutBreak >= 0.0) : "Travel time cannot be negative!";
            if (permittedTimeToTravel >= travelTimeWithoutBreak) {
                arrived = true;
                timeOfArrival = curTime += travelTimeWithoutBreak;
                timeSinceLastLongBreak += travelTimeWithoutBreak;
                timeSinceLastShortBreak += travelTimeWithoutBreak;
                this.logger.info("\tDriving the remaining distance to goal without a break. This takes {} (min time for this distance is {})", (Object)travelTimeWithoutBreak, (Object)(minTravelTime * (1.0 - shareOfTheTripDone)));
                continue;
            }
            this.logger.info("\tCurrently achieved {}% of the trip.", (Object)shareOfTheTripDone);
            this.logger.info("\tCannot reach the goal within the permitted {}, because the travel without a break would take {}", (Object)permittedTimeToTravel, (Object)travelTimeWithoutBreak);
            shareOfTheTripDone = this.getShareOfTripWhenDrivingOverEdgeAtAGivenTimeForAGivenTimeWithoutDoingABreak(minTravelTime, curTime, shareOfTheTripDone, permittedTimeToTravel);
            this.logger.info("\tDriving the permitted {}h. This allows us to finish {}% of the trip.", (Object)permittedTimeToTravel, (Object)(shareOfTheTripDone * 100.0));
            if (permittedTimeToTravel == timeToNextLongBreak) {
                this.logger.info("\tDo long break, because it is necessary");
            }
            if (permittedTimeToTravel + this.durationOfShortBreak + 2.0 > timeToNextLongBreak) {
                this.logger.info("\tDo long break, because short break + 2 hours driving would require a long break anyway");
            }
            boolean bl = doLongBreak = permittedTimeToTravel == timeToNextLongBreak || permittedTimeToTravel + this.durationOfShortBreak + 2.0 >= timeToNextLongBreak;
            if (doLongBreak) {
                this.logger.info("\tDoing a long break ({}h)", (Object)this.durationOfLongBreak);
                timeSinceLastShortBreak = 0.0;
                timeSinceLastLongBreak = 0.0;
                timeToNextShortBreak = this.getTimeToNextShortBreak(0.0);
                timeToNextLongBreak = this.getTimeToNextLongBreak(curTime += permittedTimeToTravel + this.durationOfLongBreak, 0.0);
                continue;
            }
            double timeElapsed = permittedTimeToTravel + this.durationOfShortBreak;
            this.logger.info("\tDoing a short break ({}h)", (Object)this.durationOfShortBreak);
            timeSinceLastShortBreak = 0.0;
            timeToNextShortBreak = this.getTimeToNextShortBreak(0.0);
            timeToNextLongBreak = this.getTimeToNextLongBreak(curTime += timeElapsed, timeSinceLastLongBreak += timeElapsed);
        }
        double travelDuration = curTime - n.getTime();
        this.logger.info("Finished travel simulation. Travel duration: {}", (Object)travelDuration);
        ShortArrayList tourToHere = new ShortArrayList(n.getCurTour());
        tourToHere.add(destination);
        return new EnhancedTTSPState(n, destination, timeOfArrival, timeSinceLastShortBreak, timeSinceLastLongBreak);
    }

    public ShortList getPossibleRemainingDestinationsInState(EnhancedTTSPState n) {
        boolean openPlaces;
        short curLoc = n.getCurLocation();
        ShortArrayList possibleDestinationsToGoFromhere = new ShortArrayList();
        ShortList seenPlaces = n.getCurTour();
        int k = 0;
        boolean bl = openPlaces = seenPlaces.size() < this.getPossibleDestinations().size() - 1;
        if (n.getCurTour().size() >= this.getPossibleDestinations().size()) {
            throw new IllegalArgumentException("We have already visited everything!");
        }
        assert (openPlaces || curLoc != 0) : "There are no open places (out of the " + this.getPossibleDestinations().size() + ", " + seenPlaces.size() + " of which have already been seen) but we are still in the initial position. This smells like a strange TSP.";
        if (openPlaces) {
            ShortListIterator shortListIterator = this.getPossibleDestinations().iterator();
            while (shortListIterator.hasNext()) {
                short l = (Short)shortListIterator.next();
                if (k++ == 0 || l == curLoc || seenPlaces.contains(l)) continue;
                possibleDestinationsToGoFromhere.add(l);
            }
        } else {
            possibleDestinationsToGoFromhere.add((short)0);
        }
        return possibleDestinationsToGoFromhere;
    }

    private double getTimeToNextShortBreak(double timeSinceLastBreak) {
        return this.maxConsecutiveDrivingTime - timeSinceLastBreak;
    }

    private double getTimeToNextLongBreak(double time, double timeSinceLastLongBreak) {
        return Math.min(this.getTimeToNextBlock(time), this.maxDrivingTimeBetweenLongBreaks - timeSinceLastLongBreak);
    }

    private double getTimeToNextBlock(double time) {
        double timeToNextBlock = Math.ceil(time) - time;
        while (!this.blockedHours.get((int)Math.round(time + timeToNextBlock) % this.numberOfConsideredHours).booleanValue()) {
            timeToNextBlock += 1.0;
        }
        return timeToNextBlock;
    }

    public double getActualDrivingTimeWithoutBreak(double minTravelTime, double departure, double shareOfTheTripDone) {
        int t = (int)Math.round(departure);
        double travelTime = minTravelTime * (1.0 - shareOfTheTripDone);
        int departureTimeRelativeToSevenNineInterval = t > 9 ? t - 24 : t;
        double startSevenNineSubInterval = Math.max(7, departureTimeRelativeToSevenNineInterval);
        double endSevenNineSubInterval = Math.min(9.0, (double)departureTimeRelativeToSevenNineInterval + travelTime);
        double travelTimeInSevenToNineSlot = Math.max(0.0, endSevenNineSubInterval - startSevenNineSubInterval);
        int departureTimeRelativeToFourSixInterval = t > 18 ? t - 24 : t;
        double startFourSixSubInterval = Math.max(16, departureTimeRelativeToFourSixInterval);
        double endFourSixSubInterval = Math.min(18.0, (double)departureTimeRelativeToFourSixInterval + (travelTime += travelTimeInSevenToNineSlot * 0.5));
        double travelTimeInFourToSixSlot = Math.max(0.0, endFourSixSubInterval - startFourSixSubInterval);
        return travelTime += travelTimeInFourToSixSlot * 0.5;
    }

    public double getShareOfTripWhenDrivingOverEdgeAtAGivenTimeForAGivenTimeWithoutDoingABreak(double minTravelTime, double departureOfCurrentPoint, double shareOfTripDone, double drivingTime) {
        double minTravelTimeForRest = minTravelTime * (1.0 - shareOfTripDone);
        this.logger.info("\t\tMin travel time for rest: {}", (Object)minTravelTimeForRest);
        double doableMinTravelTimeForRest = minTravelTimeForRest;
        double estimatedTravelingTimeForThatPortion = 0.0;
        while (true) {
            double d;
            estimatedTravelingTimeForThatPortion = this.getActualDrivingTimeWithoutBreak(doableMinTravelTimeForRest, departureOfCurrentPoint, shareOfTripDone);
            if (!(d > drivingTime)) break;
            doableMinTravelTimeForRest -= 0.01;
        }
        this.logger.info("\t\tDoable min travel time for rest: {}. The estimated true travel time for that portion is {}", (Object)doableMinTravelTimeForRest, (Object)estimatedTravelingTimeForThatPortion);
        double additionalShare = doableMinTravelTimeForRest / minTravelTimeForRest * (1.0 - shareOfTripDone);
        this.logger.info("\t\tAdditional share: {}", (Object)additionalShare);
        return shareOfTripDone + additionalShare;
    }

    public EnhancedTTSPSolutionEvaluator getSolutionEvaluator() {
        return this.solutionEvaluator;
    }

    public double getMinTravelTimeBetweenLocations(short a, short b) {
        return Math.sqrt(Math.pow(this.xCoords.get(a) - this.xCoords.get(b), 2.0) + Math.pow(this.yCoords.get(a) - this.yCoords.get(b), 2.0));
    }

    public double getLongestMinTravelTimeBetweenTwoLocations() {
        double max = 0.0;
        for (short a = 0; a < this.locations.size(); a = (short)(a + 1)) {
            for (short b = 0; b < a; b = (short)(b + 1)) {
                max = Math.max(max, this.getMinTravelTimeBetweenLocations(a, b));
            }
        }
        return max;
    }

    public double getUpperBoundForAnyTour() {
        double maxTime = this.getLongestMinTravelTimeBetweenTwoLocations();
        double totalTimeBoundForTraveling = maxTime * (double)this.locations.size();
        int longBreaks = (int)Math.floor(totalTimeBoundForTraveling / this.maxDrivingTimeBetweenLongBreaks);
        return totalTimeBoundForTraveling + (double)longBreaks * this.durationOfLongBreak;
    }

    public String toString() {
        return "EnhancedTTSP [startLocation=" + this.startLocation + ", numberOfConsideredHours=" + this.numberOfConsideredHours + ", blockedHours=" + this.blockedHours + ", hourOfDeparture=" + this.hourOfDeparture + ", durationOfShortBreak=" + this.durationOfShortBreak + ", durationOfLongBreak=" + this.durationOfLongBreak + ", maxConsecutiveDrivingTime=" + this.maxConsecutiveDrivingTime + ", maxDrivingTimeBetweenLongBreaks=" + this.maxDrivingTimeBetweenLongBreaks + ", possibleDestinations=" + this.possibleDestinations + ", solutionEvaluator=" + this.solutionEvaluator + "]";
    }
}

