/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.enhancedttsp;

import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPState;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.List;

public abstract class EnhancedTTSPBinaryTelescopeNode {
    protected final EnhancedTTSPBinaryTelescopeNode parent;

    public EnhancedTTSPBinaryTelescopeNode(EnhancedTTSPBinaryTelescopeNode parent) {
        this.parent = parent;
    }

    public abstract EnhancedTTSPState getState();

    public abstract short getCurLocation();

    public abstract ShortList getCurTour();

    public static class EnhancedTTSPBinaryTelescopeDestinationDecisionNode
    extends EnhancedTTSPBinaryTelescopeNode {
        private final boolean bitChoice;

        public EnhancedTTSPBinaryTelescopeDestinationDecisionNode(EnhancedTTSPBinaryTelescopeNode parent, boolean bitChoice) {
            super(parent);
            this.bitChoice = bitChoice;
        }

        @Override
        public ShortList getCurTour() {
            return this.parent.getCurTour();
        }

        @Override
        public short getCurLocation() {
            return this.parent.getCurLocation();
        }

        public boolean isBitChoice() {
            return this.bitChoice;
        }

        public List<Boolean> getField() {
            if (this.parent instanceof EnhancedTTSPBinaryTelescopeDeterminedDestinationNode) {
                ArrayList<Boolean> l = new ArrayList<Boolean>();
                l.add(this.bitChoice);
                return l;
            }
            List<Boolean> l = ((EnhancedTTSPBinaryTelescopeDestinationDecisionNode)this.parent).getField();
            l.add(this.bitChoice);
            return l;
        }

        @Override
        public EnhancedTTSPState getState() {
            return this.parent.getState();
        }

        public String toString() {
            return "EnhancedTTSPBinaryTelescopeDestinationDecisionNode [bitChoice=" + this.bitChoice + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bitChoice ? 1231 : 1237);
            return result += this.parent.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnhancedTTSPBinaryTelescopeDestinationDecisionNode other = (EnhancedTTSPBinaryTelescopeDestinationDecisionNode)obj;
            if (this.bitChoice != other.bitChoice) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }
    }

    public static class EnhancedTTSPBinaryTelescopeDeterminedDestinationNode
    extends EnhancedTTSPBinaryTelescopeNode {
        private final EnhancedTTSPState state;

        public EnhancedTTSPBinaryTelescopeDeterminedDestinationNode(EnhancedTTSPBinaryTelescopeNode parent, EnhancedTTSPState state) {
            super(parent);
            this.state = state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnhancedTTSPBinaryTelescopeDeterminedDestinationNode other = (EnhancedTTSPBinaryTelescopeDeterminedDestinationNode)obj;
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }

        @Override
        public short getCurLocation() {
            return this.state.getCurLocation();
        }

        @Override
        public ShortList getCurTour() {
            return this.state.getCurTour();
        }

        @Override
        public EnhancedTTSPState getState() {
            return this.state;
        }

        public String toString() {
            return "EnhancedTTSPBinaryTelescopeDeterminedDestinationNode [state=" + this.state + "]";
        }
    }
}

