/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.enhancedttsp;

import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSP;
import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPState;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.util.HashSet;
import org.api4.java.common.attributedobjects.IObjectEvaluator;

public class EnhancedTTSPSolutionEvaluator
implements IObjectEvaluator<ShortList, Double> {
    private final EnhancedTTSP problem;

    public EnhancedTTSPSolutionEvaluator(EnhancedTTSP problem) {
        this.problem = problem;
    }

    public Double evaluate(ShortList solutionTour) {
        EnhancedTTSPState state = this.problem.getInitalState();
        HashSet<Short> seenLocations = new HashSet<Short>();
        ShortListIterator shortListIterator = solutionTour.iterator();
        while (shortListIterator.hasNext()) {
            short next = (Short)shortListIterator.next();
            try {
                if (seenLocations.contains(next)) {
                    throw new IllegalArgumentException("Given tour is not a valid (partial) solution. Location " + next + " is contained at least twice!");
                }
                seenLocations.add(next);
                state = this.problem.computeSuccessorState(state, next);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot evaluate tour " + solutionTour + " due to an error in successor computation of " + state + " with next step " + next + ". Message: " + e.getMessage());
            }
        }
        return state.getTime() - this.problem.getHourOfDeparture();
    }
}

