/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.enhancedttsp.locationgenerator;

import ai.libs.jaicore.problems.enhancedttsp.ITSPLocationGenerator;
import ai.libs.jaicore.problems.enhancedttsp.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterBasedGenerator
implements ITSPLocationGenerator {
    private ITSPLocationGenerator clusterLocationGenerator;
    private ITSPLocationGenerator inClusterLocationGenerator;
    private double density;
    private int clusterRadius;
    private double minDistanceBetweenClusters;
    private Random random;

    public ClusterBasedGenerator(ITSPLocationGenerator clusterLocationGenerator, ITSPLocationGenerator inClusterLocationGenerator, double density, int clusterRadius, double minDistanceBetweenClusters, Random random) {
        this.clusterLocationGenerator = clusterLocationGenerator;
        this.inClusterLocationGenerator = inClusterLocationGenerator;
        this.density = density;
        this.clusterRadius = clusterRadius;
        this.minDistanceBetweenClusters = minDistanceBetweenClusters;
        this.random = random;
    }

    @Override
    public List<Location> getLocations(int n, double centerX, double centerY, double radius, double minDistance) {
        if (minDistance > (double)(2 * this.clusterRadius)) {
            throw new IllegalArgumentException("");
        }
        int locationsPerCluster = (int)Math.ceil(this.density * (double)n);
        int numClusters = (int)Math.ceil((double)n * 1.0 / (double)locationsPerCluster);
        List<Location> clusterCentroids = this.clusterLocationGenerator.getLocations(numClusters, centerX, centerY, radius, (double)(2 * this.clusterRadius) + this.minDistanceBetweenClusters);
        ArrayList<Location> locations = new ArrayList<Location>(n);
        AtomicInteger ai = new AtomicInteger(0);
        for (int i = 0; i < numClusters; ++i) {
            Location cl = clusterCentroids.get(i);
            List<Location> localLocs = this.inClusterLocationGenerator.getLocations(locationsPerCluster, cl.getX(), cl.getY(), this.clusterRadius, minDistance);
            localLocs.forEach(l -> locations.add(new Location((short)ai.getAndIncrement(), l.getX(), l.getY())));
        }
        Collections.shuffle(locations, this.random);
        while (locations.size() > n) {
            locations.remove(0);
        }
        return locations;
    }
}

