/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.knapsack;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.problems.knapsack.KnapsackProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class EnumeratingKnapsackSolver {
    public Collection<Set<String>> getSolutions(KnapsackProblem kp) throws InterruptedException {
        ArrayList<Set<String>> solutions = new ArrayList<Set<String>>();
        Set<String> objectsAsSet = kp.getObjects();
        for (Collection<String> selection : SetUtil.powerset(objectsAsSet)) {
            double weight = 0.0;
            for (String item : selection) {
                weight += kp.getWeights().get(item).doubleValue();
            }
            if (weight > kp.getKnapsackCapacity()) continue;
            double remainingWeight = kp.getKnapsackCapacity() - weight;
            Collection<String> missingObjects = SetUtil.difference(objectsAsSet, selection);
            boolean oneMoreFits = false;
            for (String missingObject : missingObjects) {
                if (!(kp.getWeights().get(missingObject) < remainingWeight)) continue;
                oneMoreFits = true;
                break;
            }
            if (oneMoreFits || selection.isEmpty()) continue;
            solutions.add(new HashSet<String>(selection));
        }
        if (solutions.isEmpty()) {
            solutions.addAll(new HashSet());
        }
        return solutions;
    }
}

