/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.knapsack;

import java.util.Set;

public class KnapsackConfiguration {
    private final Set<String> packedObjects;
    private final Set<String> remainingObjects;
    private final double usedCapacity;

    public KnapsackConfiguration(Set<String> packedObjects, Set<String> remainingObjects, double usedCapacity) {
        this.packedObjects = packedObjects;
        this.remainingObjects = remainingObjects;
        this.usedCapacity = usedCapacity;
    }

    public Set<String> getPackedObjects() {
        return this.packedObjects;
    }

    public double getUsedCapacity() {
        return this.usedCapacity;
    }

    public Set<String> getRemainingObjects() {
        return this.remainingObjects;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packedObjects == null ? 0 : this.packedObjects.hashCode());
        result = 31 * result + (this.remainingObjects == null ? 0 : this.remainingObjects.hashCode());
        long temp = Double.doubleToLongBits(this.usedCapacity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KnapsackConfiguration other = (KnapsackConfiguration)obj;
        if (this.packedObjects == null ? other.packedObjects != null : !this.packedObjects.equals(other.packedObjects)) {
            return false;
        }
        if (this.remainingObjects == null ? other.remainingObjects != null : !this.remainingObjects.equals(other.remainingObjects)) {
            return false;
        }
        return Double.doubleToLongBits(this.usedCapacity) == Double.doubleToLongBits(other.usedCapacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.packedObjects);
        sb.append("-<" + this.usedCapacity + ">");
        return sb.toString();
    }
}

