/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.knapsack;

import ai.libs.jaicore.problems.knapsack.KnapsackConfiguration;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.api4.java.common.attributedobjects.IObjectEvaluator;

public class KnapsackProblem
implements Serializable {
    private final Set<String> objects;
    private final Map<String, Double> values;
    private final Map<String, Double> weights;
    private final Map<Set<String>, Double> bonusPoints;
    private final double knapsackCapacity;

    public KnapsackProblem(Set<String> objects, Map<String, Double> values, Map<String, Double> weights, Map<Set<String>, Double> bonusPoints, double knapsackCapacity) {
        this.objects = objects;
        this.values = values;
        this.weights = weights;
        this.bonusPoints = bonusPoints;
        this.knapsackCapacity = knapsackCapacity;
    }

    public double getKnapsackCapacity() {
        return this.knapsackCapacity;
    }

    public IObjectEvaluator<KnapsackConfiguration, Double> getSolutionEvaluator() {
        return packedKnapsack -> {
            if (packedKnapsack == null || packedKnapsack.getUsedCapacity() > this.knapsackCapacity) {
                return Double.MAX_VALUE;
            }
            double packedValue = 0.0;
            for (String string : packedKnapsack.getPackedObjects()) {
                packedValue += this.values.get(string).doubleValue();
            }
            for (Set set : this.bonusPoints.keySet()) {
                boolean allContained = true;
                for (String object : set) {
                    if (packedKnapsack.getPackedObjects().contains(object)) continue;
                    allContained = false;
                    break;
                }
                if (!allContained) continue;
                packedValue += this.bonusPoints.get(set).doubleValue();
            }
            return packedValue * -1.0;
        };
    }

    public Set<String> getObjects() {
        return this.objects;
    }

    public Map<String, Double> getValues() {
        return this.values;
    }

    public Map<String, Double> getWeights() {
        return this.weights;
    }

    public Map<Set<String>, Double> getBonusPoints() {
        return this.bonusPoints;
    }

    public String toString() {
        return "KnapsackProblem [objects=" + this.objects + ", values=" + this.values + ", weights=" + this.weights + ", bonusPoints=" + this.bonusPoints + ", knapsackCapacity=" + this.knapsackCapacity + "]";
    }
}

