/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling.openshop;

import ai.libs.jaicore.problems.scheduling.openshop.Job;
import ai.libs.jaicore.problems.scheduling.openshop.OpenShopProblem;
import ai.libs.jaicore.problems.scheduling.openshop.Schedule;
import java.util.function.BiFunction;

public enum OpenShopMetric {
    TOTALFLOWTIME((p, s) -> p.getJobs().values().stream().mapToInt(s::getJobFlowTime).reduce((r, c) -> r + c).getAsInt()),
    TOTALTARDINESS((p, s) -> p.getJobs().values().stream().mapToInt(s::getJobTardiness).reduce((r, c) -> r + c).getAsInt()),
    TOTALFLOWTIME_WEIGHTED((p, s) -> p.getJobs().values().stream().mapToInt(j -> j.getWeight() * s.getJobFlowTime((Job)j)).reduce((r, c) -> r + c).getAsInt()),
    TOTALTARDINESS_WEIGHTED((p, s) -> p.getJobs().values().stream().mapToInt(j -> j.getWeight() * s.getJobTardiness((Job)j)).reduce((r, c) -> r + c).getAsInt()),
    MAKESPAN((p, s) -> (double)p.getOperations().values().stream().map(s::getEndTimeOfOperation).max(Double::compare).get()),
    MAXTARDINESS((p, s) -> p.getJobs().values().stream().mapToInt(s::getJobTardiness).max().getAsInt()),
    NUM_TARDY_JOB((p, s) -> p.getJobs().values().stream().filter(j -> s.getJobTardiness((Job)j) > 0).count());

    private final BiFunction<OpenShopProblem, Schedule, Double> metricFunction;

    private OpenShopMetric(BiFunction<OpenShopProblem, Schedule, Double> metricFunction) {
        this.metricFunction = metricFunction;
    }

    public double getScore(OpenShopProblem problem, Schedule schedule) {
        return this.metricFunction.apply(problem, schedule);
    }
}

