/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling.openshop;

import ai.libs.jaicore.problems.scheduling.openshop.Job;
import ai.libs.jaicore.problems.scheduling.openshop.Machine;
import ai.libs.jaicore.problems.scheduling.openshop.OpenShopMetric;
import ai.libs.jaicore.problems.scheduling.openshop.OpenShopProblem;
import ai.libs.jaicore.problems.scheduling.openshop.Operation;
import ai.libs.jaicore.problems.scheduling.openshop.Workcenter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OpenShopProblemBuilder {
    private final Map<String, Workcenter> workcenters = new HashMap<String, Workcenter>();
    private final Map<String, Job> jobs = new HashMap<String, Job>();
    private final Map<String, Machine> machines = new HashMap<String, Machine>();
    private final Map<String, Operation> operations = new HashMap<String, Operation>();
    private OpenShopMetric metric;

    public OpenShopProblemBuilder fork() {
        OpenShopProblemBuilder copy = new OpenShopProblemBuilder();
        copy.workcenters.putAll(this.workcenters);
        copy.jobs.putAll(this.jobs);
        copy.machines.putAll(this.machines);
        copy.operations.putAll(this.operations);
        copy.metric = this.metric;
        return copy;
    }

    public OpenShopProblemBuilder withWorkcenter(String workcenterID, int[][] setupMatrix) {
        if (this.workcenters.containsKey(workcenterID)) {
            throw new IllegalArgumentException("Workcenter with id " + workcenterID + " already exists.");
        }
        this.workcenters.put(workcenterID, new Workcenter(workcenterID, setupMatrix));
        return this;
    }

    public OpenShopProblemBuilder withJob(String jobID, int releaseDate, int dueDate, int weight) {
        if (this.jobs.containsKey(jobID)) {
            throw new IllegalArgumentException("A job with ID " + jobID + " has already been defined.");
        }
        this.jobs.put(jobID, new Job(jobID, releaseDate, dueDate, weight));
        return this;
    }

    public OpenShopProblemBuilder withOperationForJob(String operationId, String jobId, int processTime, int status, String wcId) {
        Workcenter wc = this.workcenters.get(wcId);
        Job job = this.jobs.get(jobId);
        if (wc == null) {
            throw new IllegalArgumentException("No workcenter with id " + wcId + " has been defined!");
        }
        if (job == null) {
            throw new IllegalArgumentException("No job with id " + jobId + " has been defined!");
        }
        if (this.operations.containsKey(operationId)) {
            throw new IllegalArgumentException("There is already an operation with name \"" + operationId + "\" defined (in job " + this.operations.get(operationId).getJob().getJobID() + ")");
        }
        this.operations.put(operationId, new Operation(operationId, processTime, status, job, wc));
        return this;
    }

    public OpenShopProblemBuilder withMachineForWorkcenter(String machineId, String wcId, int availability, int initialState) {
        Workcenter wc = this.workcenters.get(wcId);
        if (wc == null) {
            throw new IllegalArgumentException("No workcenter with id " + wcId + " has been defined!");
        }
        if (this.machines.containsKey(machineId)) {
            throw new IllegalArgumentException("Machine with id " + machineId + " has already been defined (for work center " + this.machines.get(machineId).getWorkcenter().getWorkcenterID() + ")");
        }
        this.machines.put(machineId, new Machine(machineId, availability, initialState, wc));
        return this;
    }

    public OpenShopProblemBuilder withMetric(OpenShopMetric metric) {
        this.metric = metric;
        return this;
    }

    public OpenShopProblem build() {
        if (this.metric == null) {
            throw new IllegalStateException("No metric for schedule evaluation has been defined.");
        }
        return new OpenShopProblem(new HashMap<String, Job>(this.jobs), new HashMap<String, Workcenter>(this.workcenters), new HashMap<String, Operation>(this.operations), new HashMap<String, Machine>(this.machines), this.metric);
    }

    public Map<String, Job> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    public Map<String, Workcenter> getWorkcenters() {
        return Collections.unmodifiableMap(this.workcenters);
    }

    public Map<String, Operation> getOperations() {
        return Collections.unmodifiableMap(this.operations);
    }

    public Map<String, Machine> getMachines() {
        return Collections.unmodifiableMap(this.machines);
    }

    public Workcenter getWorkcenter(String workcenterId) {
        return this.workcenters.get(workcenterId);
    }

    public Machine getMachine(String machineId) {
        return this.machines.get(machineId);
    }

    public Operation getOperation(String operationId) {
        return this.operations.get(operationId);
    }

    public Job getJob(String jobId) {
        return this.jobs.get(jobId);
    }
}

