/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling.openshop;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.problems.scheduling.openshop.Machine;
import ai.libs.jaicore.problems.scheduling.openshop.OpenShopMetric;
import ai.libs.jaicore.problems.scheduling.openshop.OpenShopProblem;
import ai.libs.jaicore.problems.scheduling.openshop.OpenShopProblemBuilder;
import ai.libs.jaicore.problems.scheduling.openshop.Operation;
import ai.libs.jaicore.problems.scheduling.openshop.Schedule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ScheduleBuilder {
    private final OpenShopProblem problem;
    private final Set<String> assignedOperations = new HashSet<String>();
    private final List<Pair<Operation, Machine>> assignments = new ArrayList<Pair<Operation, Machine>>();

    public ScheduleBuilder(OpenShopProblemBuilder builder) {
        this(builder.fork().withMetric(OpenShopMetric.TOTALFLOWTIME).build());
    }

    public ScheduleBuilder(OpenShopProblem problem) {
        this.problem = problem;
    }

    public OpenShopProblem getProblem() {
        return this.problem;
    }

    public List<Pair<Operation, Machine>> getOrder() {
        return this.assignments;
    }

    public ScheduleBuilder assign(Operation o, Machine m) {
        if (this.assignedOperations.contains(o.getName())) {
            throw new IllegalArgumentException("Operation " + o.getName() + " has already been assigned.");
        }
        if (!o.getWorkcenter().getMachines().contains(m)) {
            throw new IllegalArgumentException("Cannot assign operation " + o.getName() + " to machine " + m.getMachineID() + ", because that machine is in work center " + m.getWorkcenter().getWorkcenterID() + ", but the operation must be executed in work center " + o.getWorkcenter().getWorkcenterID());
        }
        this.assignments.add(new Pair<Operation, Machine>(o, m));
        this.assignedOperations.add(o.getName());
        return this;
    }

    public ScheduleBuilder assign(String o, String m) {
        return this.assign(this.problem.getOperations().get(o), this.problem.getMachines().get(m));
    }

    public Schedule build() {
        Collection unassignedOperations = SetUtil.difference(this.assignments.stream().map(Pair::getX).collect(Collectors.toSet()), this.problem.getOperations().values());
        if (!unassignedOperations.isEmpty()) {
            throw new UnsupportedOperationException("Cannot create partial schedules at the moment.");
        }
        return new Schedule(this.assignments);
    }
}

