/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.timing;

import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.concurrent.TrackableTimerTask;
import ai.libs.jaicore.interrupt.Interrupter;
import ai.libs.jaicore.interrupt.InterruptionTimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedComputation {
    private static final Logger logger = LoggerFactory.getLogger(TimedComputation.class);

    private TimedComputation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T compute(Callable<T> callable, long timeoutInMs, String reasonToLogOnTimeout) throws ExecutionException, AlgorithmTimeoutedException, InterruptedException {
        GlobalTimer timer = GlobalTimer.getInstance();
        long start = System.currentTimeMillis();
        InterruptionTimerTask task = new InterruptionTimerTask("Timeout for timed computation with thread " + Thread.currentThread() + " at timestamp " + start + ": " + reasonToLogOnTimeout);
        logger.debug("Scheduling timer for interruption in {}ms with reason {}, i.e. timestamp {}.", new Object[]{timeoutInMs, start + timeoutInMs, reasonToLogOnTimeout});
        timer.schedule((TrackableTimerTask)task, timeoutInMs);
        Interrupter interrupter = Interrupter.get();
        T output = null;
        Exception caughtException = null;
        try {
            logger.debug("Starting supervised computation of {}.", callable);
            output = callable.call();
        }
        catch (Exception e) {
            caughtException = e;
        }
        finally {
            task.cancel();
        }
        int runtime = (int)(System.currentTimeMillis() - start);
        int delay = runtime - (int)timeoutInMs;
        if (caughtException != null) {
            logger.info("Timed computation has returned control after {}ms, i.e., with a delay of {}ms. Observed exception: {}. Thread interrupt flag is {}.", new Object[]{runtime, delay, caughtException.getClass().getName(), Thread.currentThread().isInterrupted()});
        } else {
            logger.info("Timed computation has returned control after {}ms, i.e., with a delay of {}ms. Observed regular output return value: {}. Thread interrupt flag is {}.", new Object[]{runtime, delay, output, Thread.currentThread().isInterrupted()});
        }
        boolean timeoutTriggered = false;
        Interrupter interrupter2 = interrupter;
        synchronized (interrupter2) {
            logger.debug("Checking for an interruption and resolving potential interrupts.");
            if (interrupter.hasCurrentThreadBeenInterruptedWithReason(task)) {
                logger.info("Thread has been interrupted internally. Resolving the interrupt (this may throw an InterruptedException).");
                timeoutTriggered = true;
                Thread.interrupted();
                try {
                    Interrupter.get().markInterruptOnCurrentThreadAsResolved(task);
                }
                catch (InterruptedException e) {
                    logger.debug("Re-interrupting current thread, because another interrupt has been open.");
                    Thread.currentThread().interrupt();
                }
            } else if (task.isTriggered()) {
                interrupter.avoidInterrupt(Thread.currentThread(), task);
                logger.info("Interrupt is external, black-listed \"{}\" for interrupts on {} and re-throwing the exception.", (Object)task, (Object)Thread.currentThread());
            }
            assert (!interrupter.hasCurrentThreadBeenInterruptedWithReason(task));
        }
        if (caughtException != null) {
            if (timeoutTriggered) {
                logger.info("Throwing TimeoutException");
                throw new AlgorithmTimeoutedException((long)delay);
            }
            if (caughtException instanceof InterruptedException) {
                logger.debug("Now re-throwing {}, which was caught in timed computation. Interrupt-flag is {}.", (Object)caughtException, (Object)Thread.currentThread().isInterrupted());
                throw (InterruptedException)caughtException;
            }
            logger.debug("Now re-throwing {}, which was caught in timed computation. Interrupt-flag is {}.", (Object)caughtException, (Object)Thread.currentThread().isInterrupted());
            throw new ExecutionException(caughtException);
        }
        logger.debug("Finished timed computation of {} after {}ms where {}ms were allowed. Interrupt-flag is {}", new Object[]{callable, runtime, timeoutInMs, Thread.currentThread().isInterrupted()});
        return output;
    }
}

