/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ArrayUtil {
    private ArrayUtil() {
    }

    private static void columnSanityCheck(int arrayLength, Collection<Integer> columnIndices) {
        if (columnIndices.stream().anyMatch(x -> x >= arrayLength || x < 0)) {
            throw new IllegalArgumentException("Cannot exclude non existing columns (" + columnIndices + "), array length: " + arrayLength);
        }
    }

    public static <T> T[] copyArrayExlcuding(T[] array, Collection<Integer> columnsToExclude) {
        ArrayUtil.columnSanityCheck(array.length, columnsToExclude);
        T[] arrayCopy = Arrays.copyOf(array, array.length - columnsToExclude.size());
        int pointer = 0;
        for (int i = 0; i < array.length; ++i) {
            if (columnsToExclude.contains(i)) continue;
            arrayCopy[pointer++] = array[i];
        }
        return arrayCopy;
    }

    public static <T> T[] copyArrayRetaining(T[] array, Collection<Integer> columnsToRetain) {
        ArrayUtil.columnSanityCheck(array.length, columnsToRetain);
        T[] arrayCopy = Arrays.copyOf(array, columnsToRetain.size());
        int pointer = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!columnsToRetain.contains(i)) continue;
            arrayCopy[pointer++] = array[i];
        }
        return arrayCopy;
    }

    public static double[][] transposeDoubleMatrix(double[][] matrix) {
        double[][] transposed = new double[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                transposed[j][i] = matrix[i][j];
            }
        }
        return transposed;
    }

    public static int[][] transposeIntegerMatrix(int[][] matrix) {
        int[][] transposed = new int[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                transposed[j][i] = matrix[i][j];
            }
        }
        return transposed;
    }

    private static String cleanArrayString(String arrayString) {
        String cleanArrayString = arrayString.trim();
        if (cleanArrayString.startsWith("[") && cleanArrayString.endsWith("]")) {
            cleanArrayString = cleanArrayString.substring(1, cleanArrayString.length() - 1);
        }
        return cleanArrayString;
    }

    public static double[] parseStringToDoubleArray(String arrayString) {
        return Arrays.stream(ArrayUtil.cleanArrayString(arrayString).split(",")).mapToDouble(Double::parseDouble).toArray();
    }

    public static int[] parseStringToIntArray(String arrayString) {
        return Arrays.stream(ArrayUtil.cleanArrayString(arrayString).split(",")).mapToInt(Integer::parseInt).toArray();
    }

    public static String[] parseStringToStringArray(String arrayString) {
        return (String[])Arrays.stream(ArrayUtil.cleanArrayString(arrayString).split(",")).toArray();
    }

    public static List<Integer> argMax(double[] array) {
        int argMax = ArrayUtil.argMaxFirst(array);
        return IntStream.range(0, array.length).filter(x -> array[x] == array[argMax]).mapToObj(Integer::valueOf).collect(Collectors.toList());
    }

    public static List<Integer> argMax(int[] array) {
        int argMax = ArrayUtil.argMaxFirst(array);
        return IntStream.range(0, array.length).filter(x -> array[x] == array[argMax]).mapToObj(Integer::valueOf).collect(Collectors.toList());
    }

    public static int argMaxFirst(int[] array) {
        Integer argMax = null;
        for (int i = 0; i < array.length; ++i) {
            if (argMax != null && array[i] <= array[argMax]) continue;
            argMax = i;
        }
        return argMax;
    }

    public static int argMaxFirst(double[] array) {
        Integer argMax = null;
        for (int i = 0; i < array.length; ++i) {
            if (argMax != null && !(array[i] > array[argMax])) continue;
            argMax = i;
        }
        return argMax;
    }

    public static List<Integer> argMin(int[] array) {
        int argMin = ArrayUtil.argMinFirst(array);
        return IntStream.range(0, array.length).filter(x -> array[x] == array[argMin]).mapToObj(Integer::valueOf).collect(Collectors.toList());
    }

    public static int argMinFirst(int[] array) {
        Integer argMin = null;
        for (int i = 0; i < array.length; ++i) {
            if (argMin != null && array[i] >= array[argMin]) continue;
            argMin = i;
        }
        return argMin;
    }

    public static double[][] transposeMatrix(double[][] matrix) {
        double[][] transposed = new double[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                transposed[j][i] = matrix[i][j];
            }
        }
        return transposed;
    }

    public static int[][] transposeMatrix(int[][] matrix) {
        int[][] transposed = new int[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                transposed[j][i] = matrix[i][j];
            }
        }
        return transposed;
    }

    public static <T> T[][] transposeMatrix(T[][] matrix) {
        Object[][] transposed = (Object[][])Array.newInstance(matrix.getClass(), matrix[0].length, matrix.length);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                transposed[j][i] = matrix[i][j];
            }
        }
        return transposed;
    }

    public static int[] thresholdDoubleToBinaryArray(double[] array, double threshold) {
        return Arrays.stream(array).mapToInt(x -> x >= threshold ? 1 : 0).toArray();
    }

    public static int[][] thresholdDoubleToBinaryMatrix(double[][] matrix, double threshold) {
        return ArrayUtil.thresholdDoubleToBinaryMatrix(matrix, IntStream.range(0, matrix[0].length).mapToDouble(x -> threshold).toArray());
    }

    public static int[][] thresholdDoubleToBinaryMatrix(double[][] matrix, double[] threshold) {
        int[][] thresholdedMatrix = new int[matrix[0].length][];
        IntStream.range(0, matrix[0].length).forEach(l -> {
            thresholdedMatrix[l] = ArrayUtil.thresholdDoubleToBinaryArray(ArrayUtil.extractColumn(matrix, l), threshold[l]);
        });
        return ArrayUtil.transposeMatrix(thresholdedMatrix);
    }

    public static double[] extractColumn(double[][] matrix, int columnIndex) {
        double[] column = new double[matrix.length];
        IntStream.range(0, matrix.length).forEach(x -> {
            column[x] = matrix[x][columnIndex];
        });
        return column;
    }

    public static int[] extractColumn(int[][] matrix, int columnIndex) {
        int[] column = new int[matrix.length];
        IntStream.range(0, matrix.length).forEach(x -> {
            column[x] = matrix[x][columnIndex];
        });
        return column;
    }

    public static void add(double[] sum, double[] summand) {
        if (sum.length != summand.length) {
            throw new IllegalArgumentException("The array must be of the same length.");
        }
        IntStream.range(0, sum.length).forEach(x -> {
            int n = x;
            sum[n] = sum[n] + summand[x];
        });
    }

    public static <T> T[] mergeArrays(T[] array0, T[] array1) {
        Object[] merged = (Object[])Array.newInstance(array0.getClass(), array0.length + array1.length);
        System.arraycopy(array0, 0, merged, 0, array0.length);
        System.arraycopy(array1, 0, merged, array0.length, array1.length);
        return merged;
    }
}

