/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.sets.SetUtil;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceFile
extends File {
    private static final long serialVersionUID = -404232145050366072L;
    private final String pathName;

    public ResourceFile(String pathname) {
        super(pathname);
        this.pathName = pathname;
    }

    public ResourceFile(ResourceFile baseFile, String pathname) {
        super(ResourceFile.getPathName(baseFile, pathname));
        this.pathName = ResourceFile.getPathName(baseFile, pathname);
    }

    private static String getPathName(ResourceFile baseFile, String pathName) {
        LinkedList<String> pathConstruct = new LinkedList<String>();
        LinkedList<String> concatPaths = new LinkedList<String>();
        concatPaths.addAll(SetUtil.explode(baseFile.getPathName(), "/"));
        concatPaths.addAll(SetUtil.explode(pathName, "/"));
        for (String pathElement : concatPaths) {
            if (pathElement.equals(".")) continue;
            if (pathElement.equals("..")) {
                if (pathConstruct.isEmpty()) {
                    throw new IllegalArgumentException("Cannot construct path from " + baseFile.getPathName() + " and " + pathName);
                }
                pathConstruct.remove(pathConstruct.size() - 1);
                continue;
            }
            pathConstruct.add(pathElement);
        }
        return SetUtil.implode(pathConstruct, "/");
    }

    public InputStream getInputStream() {
        return this.getClass().getClassLoader().getResourceAsStream(this.pathName);
    }

    public final String getPathName() {
        return this.pathName;
    }

    @Override
    public final String getPath() {
        return this.getPathName();
    }

    @Override
    public final ResourceFile getParentFile() {
        List<String> stringList = SetUtil.explode(this.pathName, "/");
        if (!stringList.isEmpty()) {
            stringList.remove(stringList.size() - 1);
            return new ResourceFile(SetUtil.implode(stringList, "/"));
        }
        return null;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceFile)) {
            return false;
        }
        ResourceFile other = (ResourceFile)obj;
        return new EqualsBuilder().append((Object)this.pathName, (Object)other.pathName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.pathName).toHashCode();
    }
}

