/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.FileUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileHandler
implements Closeable {
    private static final String ERR_MSG_CANNOT_CLOSE_READER = "Cannot close reader";
    private Logger logger = LoggerFactory.getLogger(TempFileHandler.class);
    private File tempFileDirectory;
    private Map<String, File> tempFiles;
    private Map<String, BufferedReader> tempFileReaders;
    private Map<String, FileWriter> tempFileWriters;

    public TempFileHandler(File tempFileDirectory) {
        this.tempFileDirectory = tempFileDirectory;
        this.tempFiles = new HashMap<String, File>();
        this.tempFileReaders = new HashMap<String, BufferedReader>();
        this.tempFileWriters = new HashMap<String, FileWriter>();
        if (!tempFileDirectory.exists()) {
            tempFileDirectory.mkdirs();
        }
    }

    public TempFileHandler() {
        this(new File(System.getProperty("user.home") + "/.ailibs"));
    }

    public File createTempFile() {
        return this.createTempFile(UUID.randomUUID().toString());
    }

    public File createTempFile(String name) {
        String path = this.tempFileDirectory.getAbsolutePath() + File.separator + name;
        FileUtil.touch(path);
        File file = new File(path);
        file.deleteOnExit();
        this.tempFiles.put(name, file);
        return file;
    }

    public boolean doesTempFileExist(String name) {
        return new File(this.tempFileDirectory + File.separator + name).exists();
    }

    public File getTempFile(String name) {
        if (!this.tempFiles.containsKey(name)) {
            if (!this.doesTempFileExist(name)) {
                throw new IllegalArgumentException("The temporary file " + name + " does not exist!");
            }
            this.tempFiles.put(name, new File(this.tempFileDirectory.getAbsolutePath() + File.separator + name));
        }
        return this.tempFiles.get(name);
    }

    public BufferedReader getFileReaderForTempFile(String uuid) throws FileNotFoundException {
        if (this.tempFileReaders.containsKey(uuid)) {
            try {
                this.tempFileReaders.get(uuid).close();
            }
            catch (IOException e) {
                this.logger.error(ERR_MSG_CANNOT_CLOSE_READER, (Throwable)e);
            }
            this.tempFileReaders.remove(uuid);
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.tempFiles.get(uuid)));
        this.tempFileReaders.put(uuid, reader);
        return reader;
    }

    public FileWriter getFileWriterForTempFile(String uuid) throws IOException {
        if (this.tempFileWriters.containsKey(uuid)) {
            return this.tempFileWriters.get(uuid);
        }
        FileWriter writer = new FileWriter(this.tempFiles.get(uuid));
        this.tempFileWriters.put(uuid, writer);
        return writer;
    }

    public void deleteTempFile(String uuid) {
        if (this.tempFileReaders.containsKey(uuid)) {
            try {
                this.tempFileReaders.get(uuid).close();
            }
            catch (IOException e) {
                this.logger.error(ERR_MSG_CANNOT_CLOSE_READER, (Throwable)e);
            }
            this.tempFileReaders.remove(uuid);
        }
        if (this.tempFileWriters.containsKey(uuid)) {
            try {
                this.tempFileWriters.get(uuid).close();
            }
            catch (IOException e) {
                this.logger.error(ERR_MSG_CANNOT_CLOSE_READER, (Throwable)e);
            }
            this.tempFileWriters.remove(uuid);
        }
        if (this.tempFiles.containsKey(uuid)) {
            try {
                Files.delete(this.tempFiles.get(uuid).toPath());
            }
            catch (IOException e) {
                this.logger.error(String.format("Cannot delete file for UUID %s", uuid), (Throwable)e);
            }
            this.tempFiles.remove(uuid);
        }
    }

    public void cleanUp() {
        HashSet<String> uuids = new HashSet<String>(this.tempFiles.keySet());
        for (String uuid : uuids) {
            this.deleteTempFile(uuid);
        }
    }

    @Override
    public void close() throws IOException {
        this.cleanUp();
    }

    public String getTempFileDirPath() {
        return this.tempFileDirectory.getAbsolutePath();
    }
}

