/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.EAlgorithmState;
import ai.libs.jaicore.interrupt.Interrupter;
import ai.libs.jaicore.timing.TimedComputation;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.algorithm.exceptions.ExceptionInAlgorithmIterationException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.event.IRelaxedEventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAlgorithm<I, O>
implements IAlgorithm<I, O>,
ILoggingCustomizable,
IRelaxedEventEmitter {
    private Logger logger = LoggerFactory.getLogger(AAlgorithm.class);
    private String loggerName;
    private IOwnerBasedAlgorithmConfig config;
    private final I input;
    private long shutdownInitialized = -1L;
    private long activationTime = -1L;
    private String id;
    private long deadline = -1L;
    private long timeOfTimeoutDetection = -1L;
    private long canceled = -1L;
    private final Set<Thread> activeThreads = new HashSet<Thread>();
    private EAlgorithmState state = EAlgorithmState.CREATED;
    private final EventBus eventBus = new EventBus();
    private final List<Object> listeners = new ArrayList<Object>();
    private int timeoutPrecautionOffset = 100;
    private static final int MIN_RUNTIME_FOR_OBSERVED_TASK = 50;
    private static final String INTERRUPT_NAME_SUFFIX = "-shutdown";

    protected AAlgorithm(I input) {
        this(null, input);
    }

    protected AAlgorithm(IOwnerBasedAlgorithmConfig config, I input) {
        this.input = input;
        this.config = config != null ? config : (IOwnerBasedAlgorithmConfig)ConfigFactory.create(IOwnerBasedAlgorithmConfig.class, (Map[])new Map[0]);
    }

    public Iterator<IAlgorithmEvent> iterator() {
        return this;
    }

    public boolean hasNext() {
        return this.state != EAlgorithmState.INACTIVE;
    }

    public IAlgorithmEvent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.nextWithException();
        }
        catch (Exception e) {
            this.unregisterThreadAndShutdown();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ExceptionInAlgorithmIterationException(e);
        }
    }

    public I getInput() {
        return this.input;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
        this.listeners.add(listener);
    }

    public List<Object> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int getNumCPUs() {
        return this.getConfig().cpus();
    }

    public void setNumCPUs(int numberOfCPUs) {
        this.getConfig().setProperty("cpus", numberOfCPUs + "");
    }

    public void setMaxNumThreads(int maxNumberOfThreads) {
        this.getConfig().setProperty("threads", maxNumberOfThreads + "");
    }

    public final void setTimeout(long timeout, TimeUnit timeUnit) {
        this.setTimeout(new Timeout(timeout, timeUnit));
        this.logger.info("Timeout set to {}s", (Object)this.getTimeout().seconds());
    }

    public void setTimeout(Timeout timeout) {
        this.logger.info("Setting timeout to {}ms", (Object)timeout.milliseconds());
        this.getConfig().setProperty("timeout", timeout.milliseconds() + "");
    }

    public boolean isTimeoutDefined() {
        return this.getTimeout().milliseconds() > 0L;
    }

    public int getTimeoutPrecautionOffset() {
        return this.timeoutPrecautionOffset;
    }

    public void setTimeoutPrecautionOffset(int timeoutPrecautionOffset) {
        this.timeoutPrecautionOffset = timeoutPrecautionOffset;
    }

    public Timeout getTimeout() {
        return new Timeout(this.getConfig().timeout(), TimeUnit.MILLISECONDS);
    }

    public boolean isTimeouted() {
        if (this.timeOfTimeoutDetection > 0L) {
            return true;
        }
        if (this.deadline > 0L && System.currentTimeMillis() >= this.deadline) {
            this.timeOfTimeoutDetection = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected long getDeadline() {
        return this.deadline;
    }

    protected Timeout getRemainingTimeToDeadline() {
        if (this.deadline < 0L) {
            return new Timeout(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        return new Timeout(this.deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public boolean isStopCriterionSatisfied() {
        return this.isCanceled() || this.isTimeouted() || Thread.currentThread().isInterrupted();
    }

    public boolean isCanceled() {
        return this.canceled > 0L;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getClass().getName() + "-" + System.currentTimeMillis();
        }
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTermination(boolean shutdownOnStoppingCriterion) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.logger.debug("Checking Termination");
        Thread t = Thread.currentThread();
        Interrupter interrupter = Interrupter.get();
        if (t.isInterrupted()) {
            boolean isIntentionalInterrupt;
            Interrupter interrupter2 = interrupter;
            synchronized (interrupter2) {
                this.logger.info("Interruption detected for {}. Resetting interrupted-flag. Now checking whether this was due to a shutdown.", (Object)this.getId());
                Thread.interrupted();
                isIntentionalInterrupt = this.hasThreadBeenInterruptedDuringShutdown(t);
                if (!isIntentionalInterrupt) {
                    this.avoidReinterruptionOnShutdownOnCurrentThread();
                }
            }
            if (isIntentionalInterrupt) {
                this.logger.debug("Thread has been interrupted during shutdown (so we will not throw an InterruptedException). Resolving this interruption cause now.");
                this.resolveShutdownInterruptOnCurrentThread();
                this.logger.debug("Interrupt reason resolved. Now proceeding with termination check, which should end with a timeout or cancellation.");
                assert (this.isTimeouted() || this.isCanceled()) : "If a thread is interrupted during the shutdown, this should be caused by a timeout or a cancel!";
            } else {
                this.logger.debug("The interrupt has not been caused by a shutdown. Will throw an InterruptedException (and maybe previously shutdown if configured so).");
                if (shutdownOnStoppingCriterion) {
                    this.logger.debug("Invoking shutdown");
                    this.unregisterThreadAndShutdown();
                } else {
                    this.logger.debug("Not shutting down, because shutdown-on-stop-criterion has been set to false");
                }
                this.logger.debug("Throwing InterruptedException to communicate the interrupt to the invoker.");
                throw new InterruptedException();
            }
        }
        if (this.isTimeouted()) {
            this.logger.info("Timeout detected for {}", (Object)this.getId());
            if (shutdownOnStoppingCriterion) {
                this.logger.debug("Invoking shutdown");
                this.unregisterThreadAndShutdown();
            } else {
                this.logger.debug("Not shutting down, because shutdown-on-stop-criterion has been set to false");
            }
            this.logger.debug("Throwing TimeoutException");
            throw new AlgorithmTimeoutedException(this.timeOfTimeoutDetection - this.deadline);
        }
        if (this.isCanceled()) {
            this.logger.info("Cancel detected for {}. Cancel was issued {}ms ago.", (Object)this.getId(), (Object)(System.currentTimeMillis() - this.canceled));
            if (Thread.interrupted()) {
                this.logger.debug("Thread has been interrupted during shutdown. Resetting the flag and not invoking shutdown again.");
            }
            this.logger.debug("Throwing AlgorithmExecutionCanceledException.");
            throw new AlgorithmExecutionCanceledException(System.currentTimeMillis() - this.canceled);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No termination condition observed. Remaining time to timeout is {}", (Object)this.getRemainingTimeToDeadline());
        }
    }

    protected void checkAndConductTermination() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.checkTermination(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        AAlgorithm aAlgorithm = this;
        synchronized (aAlgorithm) {
            if (this.shutdownInitialized > 0L) {
                this.logger.info("Tried to enter shutdown for {}, but the shutdown has already been initialized in the past, so exiting the shutdown block.", (Object)this);
                return;
            }
            this.shutdownInitialized = System.currentTimeMillis();
            this.logger.info("Entering shutdown procedure for {}. Interrupting {} active threads: {}", new Object[]{this.getId(), this.activeThreads.size(), this.activeThreads});
        }
        for (Thread t : this.activeThreads) {
            this.logger.debug("Triggering interrupt on {} as part of shutdown of {}", (Object)t, (Object)this.getId());
            this.interruptThreadAsPartOfShutdown(t);
        }
        this.logger.info("Shutdown of {} completed.", (Object)this.getId());
    }

    protected void interruptThreadAsPartOfShutdown(Thread t) {
        Interrupter.get().interruptThread(t, this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    public boolean hasThreadBeenInterruptedDuringShutdown(Thread t) {
        return Interrupter.get().hasThreadBeenInterruptedWithReason(t, this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    protected void resolveShutdownInterruptOnCurrentThread() throws InterruptedException {
        Interrupter.get().markInterruptOnCurrentThreadAsResolved(this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    protected void avoidReinterruptionOnShutdownOnCurrentThread() {
        Interrupter.get().avoidInterrupt(Thread.currentThread(), this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    public boolean isShutdownInitialized() {
        return this.shutdownInitialized > 0L;
    }

    protected void unregisterThreadAndShutdown() {
        this.unregisterActiveThread();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerActiveThread() {
        if (this.shutdownInitialized > 0L) {
            this.logger.warn("Ignoring registration of thread, because the algorithm has been shutdown already");
            return;
        }
        AAlgorithm aAlgorithm = this;
        synchronized (aAlgorithm) {
            if (this.shutdownInitialized > 0L) {
                this.logger.warn("Ignoring registration of thread, because the algorithm has been shutdown already");
                return;
            }
            this.activeThreads.add(Thread.currentThread());
        }
    }

    protected void unregisterActiveThread() {
        this.logger.trace("Unregistering current thread {}", (Object)Thread.currentThread());
        this.activeThreads.remove(Thread.currentThread());
    }

    public long getActivationTime() {
        return this.activationTime;
    }

    public EAlgorithmState getState() {
        return this.state;
    }

    protected void setState(EAlgorithmState state) {
        if (state == EAlgorithmState.ACTIVE) {
            throw new IllegalArgumentException("Cannot switch state to active. Use \"activate\" instead, which will set the state to active and provide the AlgorithmInitializedEvent.");
        }
        if (state == EAlgorithmState.INACTIVE) {
            throw new IllegalArgumentException("Cannot switch state to inactive. Use \"terminate\" instead, which will set the state to inactive and provide the AlgorithmFinishedEvent.");
        }
        this.state = state;
    }

    public void cancel() {
        this.logger.info("Received cancel for algorithm {}.", (Object)this.getId());
        if (this.isCanceled()) {
            this.logger.debug("Ignoring cancel command since the algorithm has been canceled before.");
            return;
        }
        this.canceled = System.currentTimeMillis();
        this.logger.info("Cancel flag for {} is set to {}. Now invoke shutdown procedure.", (Object)this.getId(), (Object)this.canceled);
        this.shutdown();
    }

    protected AlgorithmInitializedEvent activate() {
        assert (this.state == EAlgorithmState.CREATED) : "Can only activate an algorithm as long as its state has not been changed from CREATED to something else. It is currently " + (Object)((Object)this.state);
        this.activationTime = System.currentTimeMillis();
        if (this.getTimeout().milliseconds() > 0L && this.deadline < 0L) {
            this.setDeadline();
        }
        this.state = EAlgorithmState.ACTIVE;
        AlgorithmInitializedEvent event = new AlgorithmInitializedEvent(this);
        this.eventBus.post((Object)event);
        this.logger.debug("Starting algorithm {} with problem of type {} and config {}.", new Object[]{this.getId(), this.input.getClass().getName(), this.config});
        return event;
    }

    protected void setDeadline() {
        if (this.deadline >= 0L) {
            throw new IllegalStateException();
        }
        if (this.getTimeout().milliseconds() > 0L) {
            this.deadline = System.currentTimeMillis() + this.getTimeout().milliseconds() - (long)this.timeoutPrecautionOffset;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Timeout is {}, and precaution offset is {}. Setting deadline to timestamp {}. Remaining time: {}", new Object[]{this.getTimeout(), this.timeoutPrecautionOffset, this.deadline, this.getRemainingTimeToDeadline()});
            }
        } else {
            this.deadline = System.currentTimeMillis() + 1471228928L;
            this.logger.info("No timeout defined. Setting deadline to timestamp {}. Remaining time: {}", (Object)this.deadline, (Object)this.getRemainingTimeToDeadline());
        }
    }

    protected AlgorithmFinishedEvent terminate() {
        this.logger.info("Terminating algorithm {}.", (Object)this.getId());
        this.state = EAlgorithmState.INACTIVE;
        AlgorithmFinishedEvent finishedEvent = new AlgorithmFinishedEvent(this);
        this.unregisterThreadAndShutdown();
        this.eventBus.post((Object)finishedEvent);
        return finishedEvent;
    }

    protected void post(Object e) {
        this.eventBus.post(e);
    }

    public IOwnerBasedAlgorithmConfig getConfig() {
        return this.config;
    }

    public void setConfig(IOwnerBasedAlgorithmConfig config) {
        this.config = config;
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    protected void announceTimeoutDetected() {
        this.timeOfTimeoutDetection = System.currentTimeMillis();
    }

    protected <T> T computeTimeoutAware(Callable<T> r, String reasonToLogOnTimeout, boolean shutdownOnStoppingCriterionSatisfied) throws InterruptedException, AlgorithmException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.logger.debug("Received request to execute {} with awareness of timeout {}. Currently active threads: {}.", new Object[]{r, this.getTimeout(), this.activeThreads});
        if (this.getTimeout().milliseconds() < 0L) {
            try {
                return r.call();
            }
            catch (InterruptedException e) {
                boolean interruptedDueToShutdown = this.hasThreadBeenInterruptedDuringShutdown(Thread.currentThread());
                this.logger.info("Received interrupt. Cancel flag is {}. Thread contained in interrupted by shutdown: {}", (Object)this.isCanceled(), (Object)interruptedDueToShutdown);
                if (!interruptedDueToShutdown) {
                    throw e;
                }
                this.checkTermination(shutdownOnStoppingCriterionSatisfied);
                throw new IllegalStateException("Received an interrupt and checked termination, thus, termination routine should have thrown an exception which it apparently did not!");
            }
            catch (AlgorithmExecutionCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AlgorithmException("The algorithm has failed due to an exception of a Callable.", (Throwable)e);
            }
        }
        long remainingTime = this.getRemainingTimeToDeadline().milliseconds();
        if (remainingTime < (long)(this.timeoutPrecautionOffset + 50)) {
            this.logger.debug("Only {}ms left, which is not enough to reliably continue computation. Terminating algorithm at this point, throwing an AlgorithmTimeoutedException.", (Object)remainingTime);
            this.announceTimeoutDetected();
            this.checkTermination(shutdownOnStoppingCriterionSatisfied);
        }
        try {
            return TimedComputation.compute(r, new Timeout(remainingTime - (long)this.timeoutPrecautionOffset, TimeUnit.MILLISECONDS), reasonToLogOnTimeout);
        }
        catch (AlgorithmTimeoutedException e) {
            this.logger.debug("TimedComputation has been timeouted. Setting the TimeoutDetection flag to now. Remaining time is {}ms.", (Object)this.getRemainingTimeToDeadline().milliseconds());
            this.timeOfTimeoutDetection = System.currentTimeMillis();
            this.checkTermination(shutdownOnStoppingCriterionSatisfied);
            throw new IllegalStateException("The flag for timeout detection has been set, but checkTermination did not throw an exception!");
        }
        catch (InterruptedException e) {
            this.logger.info("Received interrupt for {} during timed computation. Cancel flag is {}", (Object)this.getId(), (Object)this.isCanceled());
            assert (!Thread.currentThread().isInterrupted()) : "By java convention, the thread should not be interrupted when an InterruptedException is thrown.";
            boolean interruptedDueToShutdown = this.hasThreadBeenInterruptedDuringShutdown(Thread.currentThread());
            if (!interruptedDueToShutdown) {
                throw e;
            }
            this.resolveShutdownInterruptOnCurrentThread();
            this.checkTermination(shutdownOnStoppingCriterionSatisfied);
            throw new IllegalStateException("A stopping criterion must have been true (probably cancel), but checkTermination did not throw an exception!");
        }
        catch (ExecutionException e) {
            throw new AlgorithmException("The algorithm has failed due to an exception of Callable " + r + " with timeout log message " + reasonToLogOnTimeout, (Throwable)e);
        }
    }
}

