/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import ai.libs.jaicore.basic.sets.SetUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.api4.java.datastructure.kvstore.IKVFilter;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVStore
extends HashMap<String, Object>
implements IKVStore,
Serializable {
    private static final long serialVersionUID = 6635572555061279948L;
    private static final Logger LOGGER = LoggerFactory.getLogger(KVStore.class);
    private static final String DEFAULT_LIST_SEP = ",";
    private KVStoreCollection collection;

    public KVStore() {
    }

    public KVStore(String stringRepresentation) {
        this.readKVStoreFromDescription(stringRepresentation);
    }

    public KVStore(Map<String, Object> keyValueMap) {
        this.putAll(keyValueMap);
    }

    public KVStore(IKVStore keyValueStoreToCopy) {
        this(keyValueStoreToCopy.toString());
    }

    public String getAsString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value + "";
    }

    public Boolean getAsBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new IllegalStateException("Tried to get non-boolean value as boolean from KVStore.");
    }

    public Integer getAsInt(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return Integer.valueOf(value.toString());
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                try {
                    return (int)Double.valueOf((String)value).doubleValue();
                }
                catch (NumberFormatException e1) {
                    throw new IllegalStateException("Tired of casting this value " + value + " to a number and I give up.");
                }
            }
        }
        throw new IllegalStateException("Tried to get non-integer value as integer from KVStore. Type of value " + value + " is " + value.getClass().getName());
    }

    public Double getAsDouble(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (value instanceof Integer) {
            return Double.parseDouble(value + "");
        }
        if (value instanceof Long) {
            return Double.parseDouble(value + "");
        }
        throw new IllegalStateException("Tried to get non-double value as double from KVStore.");
    }

    public Long getAsLong(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new IllegalStateException("Tried to get non-long value as long from KVStore.");
    }

    public Short getAsShort(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        throw new IllegalStateException("Tried to get non-short value as short from KVStore.");
    }

    public Byte getAsByte(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        throw new IllegalStateException("Tried to get non-byte value as byte from KVStore.");
    }

    public <T> T getAsObject(String key, Class<T> objectClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return objectClass.getConstructor(new Class[0]).newInstance(this.get(key));
    }

    public byte[] getAsBytes(String columnClassifierObject) {
        return (byte[])this.get(columnClassifierObject);
    }

    public List<Double> getAsDoubleList(String key) {
        return this.getAsDoubleList(key, DEFAULT_LIST_SEP);
    }

    public List<Double> getAsDoubleList(String key, String separator) {
        if (this.get(key) == null) {
            return new LinkedList<Double>();
        }
        return Stream.of(this.getAsString(key).split(separator)).map(Double::valueOf).collect(Collectors.toList());
    }

    public List<Integer> getAsIntList(String key) {
        return this.getAsIntList(key, DEFAULT_LIST_SEP);
    }

    public List<Integer> getAsIntList(String key, String separator) {
        return Stream.of(this.getAsString(key).split(separator)).map(Integer::valueOf).collect(Collectors.toList());
    }

    public List<String> getAsStringList(String key) {
        return this.getAsStringList(key, DEFAULT_LIST_SEP);
    }

    public List<String> getAsStringList(String key, String separator) {
        return Stream.of(this.getAsString(key).split(separator)).map(this::trimString).collect(Collectors.toList());
    }

    public List<Boolean> getAsBooleanList(String key) {
        return this.getAsBooleanList(key, DEFAULT_LIST_SEP);
    }

    public List<Boolean> getAsBooleanList(String key, String separator) {
        return Stream.of(this.getAsString(key).split(separator)).map(Boolean::valueOf).collect(Collectors.toList());
    }

    public File getAsFile(String key) {
        Object value = this.get(key);
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        throw new IllegalStateException("Cannot return value as a file if it is not of that type.");
    }

    private String trimString(String x) {
        return x.trim();
    }

    public void readKVStoreFromDescription(String kvDescription) {
        String[] pairSplit;
        for (String kvPair : pairSplit = kvDescription.trim().split(";")) {
            String[] kvSplit = kvPair.trim().split("=");
            try {
                if (kvSplit.length == 2) {
                    this.put(kvSplit[0], kvSplit[1]);
                    continue;
                }
                this.put(kvSplit[0], "");
            }
            catch (Exception e) {
                LOGGER.error("Could not read kv store from string description", (Throwable)e);
            }
        }
    }

    public boolean matches(Map<String, String> selection) {
        boolean doesNotMatchAllSelectionCriteria = selection.entrySet().stream().anyMatch(x -> {
            boolean isEqual = this.getAsString((String)x.getKey()).equals(x.getValue());
            if (!((String)x.getValue()).contains("*")) {
                return !((String)x.getValue()).equals(this.getAsString((String)x.getKey()));
            }
            String[] exprSplit = ((String)x.getValue()).split("\\*");
            String currentValue = (String)x.getValue();
            boolean matchesPattern = true;
            for (int i = 0; i < exprSplit.length; ++i) {
                if (i == 0 && !((String)x.getValue()).startsWith("*") && !currentValue.startsWith(exprSplit[i])) {
                    matchesPattern = false;
                }
                if (currentValue.contains(exprSplit[i])) {
                    currentValue = currentValue.replaceFirst("(" + exprSplit[i] + ")", "#$#");
                    currentValue = currentValue.split("#$#")[1];
                } else {
                    matchesPattern = false;
                }
                if (i == exprSplit.length - 1 && !((String)x.getValue()).endsWith("*") && !currentValue.endsWith(exprSplit[i])) {
                    matchesPattern = false;
                }
                if (!matchesPattern) break;
            }
            return !isEqual && !matchesPattern;
        });
        return !doesNotMatchAllSelectionCriteria;
    }

    public void project(String[] filterKeys) {
        Set keysToKeep = Arrays.stream(filterKeys).collect(Collectors.toSet());
        Collection keysToRemove = SetUtil.difference(this.keySet(), keysToKeep);
        this.removeAll(keysToRemove.toArray(new String[0]));
    }

    public void removeAll(String[] removeKeys) {
        Set keysToRemove = Arrays.stream(removeKeys).collect(Collectors.toSet());
        for (String key : keysToRemove) {
            this.remove(key);
        }
    }

    public void filter(Map<String, IKVFilter> filterMap) {
        filterMap.entrySet().stream().forEach((? super T x) -> this.filter((String)x.getKey(), (IKVFilter)x.getValue()));
    }

    public void filter(String key, IKVFilter filter) {
        if (!this.containsKey(key)) {
            return;
        }
        this.put(key, filter.filter(this.get(key)));
    }

    public void serializeTo(String fileName) throws IOException {
        this.serializeTo(new File(fileName));
    }

    public void serializeTo(File file) throws IOException {
        if (file.getParent() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(this.toString());
        }
    }

    public void merge(String[] fieldKeys, String separator, String newKey) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String fieldKey : fieldKeys) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(this.getAsString(fieldKey));
            this.remove(fieldKey);
        }
        this.put(newKey, sb.toString());
    }

    public void prefixAllKeys(String prefix) {
        HashSet keySet = new HashSet(this.keySet());
        for (String key : keySet) {
            Object value = this.get(key);
            this.remove(key);
            this.put(prefix + key, value);
        }
    }

    public void renameKey(String key, String newKeyName) {
        if (this.containsKey(key)) {
            this.put(newKeyName, this.get(key));
            this.remove(key);
        }
    }

    public KVStoreCollection getCollection() {
        return this.collection;
    }

    public void setCollection(KVStoreCollection collection) {
        this.collection = collection;
    }

    public String getStringRepresentation(String[] projectionFilter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String filter : projectionFilter) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            sb.append(filter + "=" + this.getAsString(filter));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getStringRepresentation(this.keySet().toArray(new String[0]));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean isNull(String key) {
        return this.get(key) == null || this.getAsString(key).equals("null");
    }
}

