/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.api4.java.datastructure.kvstore.IKVStore;

public class KVStoreCollectionTwoLayerPartition
implements Iterable<Map.Entry<String, Map<String, KVStoreCollection>>> {
    private final String firstLayerKey;
    private final String secondLayerKey;
    private Map<String, Map<String, KVStoreCollection>> data;

    public KVStoreCollectionTwoLayerPartition(String firstLayerKey, String secondLayerKey, KVStoreCollection collection) {
        this(firstLayerKey, secondLayerKey);
        this.addAll(collection);
    }

    public KVStoreCollectionTwoLayerPartition(String firstLevelKey, String secondLevelKey) {
        this.firstLayerKey = firstLevelKey;
        this.secondLayerKey = secondLevelKey;
        this.data = new HashMap<String, Map<String, KVStoreCollection>>();
    }

    public Map<String, Map<String, KVStoreCollection>> getData() {
        return this.data;
    }

    public void add(IKVStore store) {
        String firstLevelValue = store.getAsString(this.firstLayerKey);
        String secondLevelValue = store.getAsString(this.secondLayerKey);
        if (!this.data.containsKey(firstLevelValue)) {
            HashMap<String, KVStoreCollection> secondLevelMap = new HashMap<String, KVStoreCollection>();
            secondLevelMap.put(secondLevelValue, new KVStoreCollection());
            this.data.put(firstLevelValue, secondLevelMap);
        } else if (!this.data.get(firstLevelValue).containsKey(secondLevelValue)) {
            this.data.get(firstLevelValue).put(secondLevelValue, new KVStoreCollection());
        }
        this.data.get(firstLevelValue).get(secondLevelValue).add(store);
    }

    public void addAll(KVStoreCollection collection) {
        collection.forEach(this::add);
    }

    public Set<Map.Entry<String, Map<String, KVStoreCollection>>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Iterator<Map.Entry<String, Map<String, KVStoreCollection>>> iterator() {
        return this.data.entrySet().iterator();
    }

    public String getFirstLayerKey() {
        return this.firstLayerKey;
    }

    public String getSecondLayerKey() {
        return this.secondLayerKey;
    }
}

