/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Table<V> {
    private static final String STANDARD_CSV_SEPARATOR = ";";
    private final List<String> columnIndex = new LinkedList<String>();
    private final List<String> rowIndex = new LinkedList<String>();
    private final Map<String, Map<String, V>> tableData = new HashMap<String, Map<String, V>>();

    public void add(String columnIndexValue, String rowIndexValue, V entry) {
        if (!this.rowIndex.contains(rowIndexValue)) {
            this.rowIndex.add(rowIndexValue);
        }
        if (!this.columnIndex.contains(columnIndexValue)) {
            this.columnIndex.add(columnIndexValue);
        }
        Map selectedRow = this.tableData.computeIfAbsent(rowIndexValue, t -> new HashMap());
        selectedRow.put(columnIndexValue, entry);
    }

    public String toLaTeX() {
        return this.toLaTeX("");
    }

    public String toLaTeX(String missingEntry) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\begin{tabular}{");
        for (int i = 0; i < this.columnIndex.size() + 1; ++i) {
            sb.append("l");
        }
        sb.append("}");
        Collections.sort(this.columnIndex);
        for (String c : this.columnIndex) {
            sb.append("&");
            sb.append(c);
        }
        sb.append("\\\\\n");
        for (String r : this.rowIndex) {
            sb.append(r);
            for (String c : this.columnIndex) {
                sb.append(" & ");
                Map<String, V> selectRow = this.tableData.get(r);
                if (selectRow == null) continue;
                V entry = selectRow.get(c);
                if (entry != null) {
                    sb.append(entry.toString().replace("_", "\\_"));
                    continue;
                }
                sb.append(missingEntry);
            }
            sb.append("\\\\\n");
        }
        sb.append("\\end{tabular}");
        return sb.toString();
    }

    public String toCSV(String standardValue) {
        return this.toCSV(STANDARD_CSV_SEPARATOR, standardValue);
    }

    public String toCSV(String separator, String standardValue) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.rowIndex);
        boolean first = true;
        for (String c : this.columnIndex) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(c);
        }
        sb.append("\n");
        for (String r : this.rowIndex) {
            first = true;
            for (String c : this.columnIndex) {
                Map<String, V> selectRow;
                if (first) {
                    first = false;
                } else {
                    sb.append(separator);
                }
                if ((selectRow = this.tableData.get(r)) == null) continue;
                V entry = selectRow.get(c);
                if (entry != null) {
                    sb.append(entry.toString());
                    continue;
                }
                sb.append(standardValue);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<String> getColumnsOfCSV() {
        return this.columnIndex;
    }

    public List<String> getRowsOfCSV() {
        return this.rowIndex;
    }

    public void sortColumns(Comparator<? super String> c) {
        this.columnIndex.sort(c);
    }

    public void sortRows(Comparator<? super String> c) {
        this.rowIndex.sort(c);
    }
}

