/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

public class ConfusionMetrics {
    private ConfusionMetrics() {
    }

    public static double getPrecision(int tp, int fp) {
        return tp + fp == 0 ? 1.0 : (double)tp / (double)(tp + fp);
    }

    public static double getRecall(int tp, int fn) {
        return tp + fn == 0 ? 1.0 : (double)tp / (double)(tp + fn);
    }

    public static double getTrueNegativeRate(int fp, int tn) {
        return fp + tn == 0 ? 1.0 : (double)tn / (double)(tn + fp);
    }

    public static double getNegativePredictiveValue(int tn, int fn) {
        return tn + fn == 0 ? 1.0 : (double)tn / (double)(tn + fn);
    }

    public static double getFalseNegativeRate(int tp, int fn) {
        return 1.0 - ConfusionMetrics.getRecall(tp, fn);
    }

    public static double getFallOut(int fp, int tn) {
        return 1.0 - ConfusionMetrics.getTrueNegativeRate(fp, tn);
    }

    public static double getFalseDiscoveryRate(int tp, int fp) {
        return 1.0 - ConfusionMetrics.getPrecision(tp, fp);
    }

    public static double getFalseOmissionRate(int tn, int fn) {
        return 1.0 - ConfusionMetrics.getNegativePredictiveValue(tn, fn);
    }

    public static double getPrevalenceThreshold(int tp, int fp, int tn, int fn) {
        return (Math.sqrt(ConfusionMetrics.getRecall(tp, fn) * (-ConfusionMetrics.getTrueNegativeRate(fp, tn) + 1.0)) + ConfusionMetrics.getTrueNegativeRate(fp, tn) - 1.0) / (ConfusionMetrics.getRecall(tp, fn) + ConfusionMetrics.getTrueNegativeRate(fp, tn) - 1.0);
    }

    public static double getCriticalSuccessIndex(int tp, int fp, int fn) {
        return tp + fn + fp == 0 ? 1.0 : (double)tp / (double)(tp + fn + fp);
    }

    public static double getAccuracy(int tp, int fp, int tn, int fn) {
        return tp + tn + fp + fn == 0 ? 1.0 : (double)(tp + tn) / (double)(tp + fp + tn + fn);
    }

    public static double getErrorRate(int tp, int fp, int tn, int fn) {
        return 1.0 - ConfusionMetrics.getAccuracy(tp, fp, tn, fn);
    }

    public static double getBalancedAccuracy(int tp, int fp, int tn, int fn) {
        return (ConfusionMetrics.getRecall(tp, fn) + ConfusionMetrics.getTrueNegativeRate(fp, tn)) / 2.0;
    }

    public static double getF1Score(int tp, int fp, int fn) {
        return ConfusionMetrics.getFMeasure(1.0, tp, fp, fn);
    }

    public static double getFMeasure(double beta, int tp, int fp, int fn) {
        double precision = ConfusionMetrics.getPrecision(tp, fp);
        double recall = ConfusionMetrics.getRecall(tp, fn);
        double betaSquare = Math.pow(beta, 2.0);
        if (precision + recall == 0.0) {
            return 0.0;
        }
        return (1.0 + betaSquare) * precision * recall / (betaSquare * ConfusionMetrics.getPrecision(tp, fp) + ConfusionMetrics.getRecall(tp, fn));
    }

    public static double getMatthewsCorrelationCoefficient(int tp, int fp, int tn, int fn) {
        double nominator = (double)tp * (double)tn - (double)(fp * fn);
        double denominator = Math.sqrt((double)(tp + fp) * (double)(tp + fn) * (double)(tn + fp) * (double)(tn + fn));
        return nominator / denominator;
    }

    public static double getFowlkesMallowsIndex(int tp, int fp, int fn) {
        return Math.sqrt(ConfusionMetrics.getPrecision(tp, fp) * ConfusionMetrics.getRecall(tp, fn));
    }

    public static double getInformedness(int tp, int fp, int tn, int fn) {
        return ConfusionMetrics.getRecall(tp, fn) + ConfusionMetrics.getTrueNegativeRate(fp, tn) - 1.0;
    }

    public static double getMarkedness(int tp, int fp, int tn, int fn) {
        return ConfusionMetrics.getPrecision(tp, fp) + ConfusionMetrics.getNegativePredictiveValue(tn, fn) - 1.0;
    }

    public static double getPredictedPositiveConditionRate(int tp, int fp, int tn, int fn) {
        return tp + fp + tn + fn == 0 ? 1.0 : (double)(tp + fp) / (double)(tp + fp + tn + fn);
    }

    public static double getPositiveLikelihoodRatio(int tp, int fp, int tn, int fn) {
        return ConfusionMetrics.getRecall(tp, fn) / ConfusionMetrics.getFallOut(fp, tn);
    }

    public static double getNegativeLikelihoodRatio(int tp, int fp, int tn, int fn) {
        return ConfusionMetrics.getFalseNegativeRate(tp, fn) / ConfusionMetrics.getTrueNegativeRate(fp, tn);
    }

    public static double getDiagnosticOddsRatio(int tp, int fp, int tn, int fn) {
        return ConfusionMetrics.getPositiveLikelihoodRatio(tp, fp, tn, fn) / ConfusionMetrics.getNegativeLikelihoodRatio(tp, fp, tn, fn);
    }
}

