/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import org.api4.java.common.metric.IDistanceMetric;
import org.api4.java.common.metric.IScalarDistance;

public class DynamicTimeWarping
implements IDistanceMetric {
    private IScalarDistance delta;

    public DynamicTimeWarping() {
        this((x, y) -> Math.abs(x - y));
    }

    public DynamicTimeWarping(IScalarDistance delta) {
        if (delta == null) {
            throw new IllegalArgumentException("Parameter delta must not be null.");
        }
        this.delta = delta;
    }

    @Override
    public double distance(double[] a, double[] b) {
        int i;
        int n = a.length;
        int m = b.length;
        double[][] matrix = new double[n + 1][m + 1];
        for (i = 1; i <= n; ++i) {
            matrix[i][0] = Double.MAX_VALUE;
        }
        for (int j = 1; j <= m; ++j) {
            matrix[0][j] = Double.MAX_VALUE;
        }
        matrix[0][0] = 0.0;
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                double cost = this.delta.distance(a[i - 1], b[j - 1]);
                double mini = Math.min(matrix[i - 1][j], Math.min(matrix[i][j - 1], matrix[i - 1][j - 1]));
                matrix[i][j] = cost + mini;
            }
        }
        return matrix[n][m];
    }

    public double distanceWithWindow(double[] a, double[] b, int w) {
        int i;
        int n = a.length;
        int m = b.length;
        double[][] matrix = new double[n + 1][m + 1];
        w = Math.max(w, Math.abs(n - m));
        for (i = 1; i <= n; ++i) {
            matrix[i][0] = Double.MAX_VALUE;
        }
        for (int j = 1; j <= m; ++j) {
            matrix[0][j] = Double.MAX_VALUE;
        }
        matrix[0][0] = 0.0;
        for (i = 1; i <= n; ++i) {
            for (int j = Math.max(1, i - w); j <= Math.min(m, i + w); ++j) {
                double cost = this.delta.distance(a[i - 1], b[j - 1]);
                double mini = Math.min(matrix[i - 1][j], Math.min(matrix[i][j - 1], matrix[i - 1][j - 1]));
                matrix[i][j] = cost + mini;
            }
        }
        return matrix[n][m];
    }
}

