/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import ai.libs.jaicore.basic.metric.ScalarDistanceUtil;
import org.api4.java.common.metric.IScalarDistance;
import org.api4.java.common.metric.ITimeseriesDistanceMetric;

public class TimeWarpEditDistance
implements ITimeseriesDistanceMetric {
    private double nu;
    private double lambda;
    private IScalarDistance d;

    public TimeWarpEditDistance(double lambda, double nu, IScalarDistance d) {
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Parameter lambda must be greater or equal to zero.");
        }
        if (nu < 0.0) {
            throw new IllegalArgumentException("Parameter nu must be greater or equal to zero.");
        }
        if (d == null) {
            throw new IllegalArgumentException("Parameter d must not be null.");
        }
        this.lambda = lambda;
        this.nu = nu;
        this.d = d;
    }

    public TimeWarpEditDistance(double lambda, double nu) {
        this(lambda, nu, ScalarDistanceUtil.getSquaredDistance());
    }

    @Override
    public double distance(double[] a, double[] tA, double[] b, double[] tB) {
        int i;
        int n = a.length;
        int m = b.length;
        double[][] dp = new double[n + 1][m + 1];
        for (i = 1; i <= n; ++i) {
            dp[i][0] = Double.MAX_VALUE;
        }
        for (i = 1; i <= m; ++i) {
            dp[0][i] = Double.MAX_VALUE;
        }
        dp[0][0] = 0.0;
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                double minimum;
                double c3;
                double c2;
                double c1;
                if (i == 1 && j == 1) {
                    c1 = dp[i - 1][j] + this.d.distance(0.0, a[i - 1]) + this.nu * tA[i - 1] + this.lambda;
                    c2 = dp[i][j - 1] + this.d.distance(0.0, b[j - 1]) + this.nu * tB[j - 1] + this.lambda;
                    c3 = dp[i - 1][j - 1] + this.d.distance(a[i - 1], b[i - 1]) + this.nu * Math.abs(tA[i - 1] - tB[j - 1]);
                } else if (i == 1) {
                    c1 = dp[i - 1][j] + this.d.distance(0.0, a[i - 1]) + this.nu * tA[i - 1] + this.lambda;
                    c2 = dp[i][j - 1] + this.d.distance(b[j - 2], b[j - 1]) + this.nu * (tB[j - 1] - tB[j - 2]) + this.lambda;
                    c3 = dp[i - 1][j - 1] + this.d.distance(a[i - 1], b[i - 1]) + this.d.distance(0.0, b[j - 2]) + this.nu * (Math.abs(tA[i - 1] - tB[j - 1]) + tB[j - 2]);
                } else if (j == 1) {
                    c1 = dp[i - 1][j] + this.d.distance(a[i - 2], a[i - 1]) + this.nu * (tA[i - 1] - tA[i - 2]) + this.lambda;
                    c2 = dp[i][j - 1] + this.d.distance(0.0, b[j - 1]) + this.nu * tB[j - 1] + this.lambda;
                    c3 = dp[i - 1][j - 1] + this.d.distance(a[i - 1], b[i - 1]) + this.d.distance(a[i - 2], 0.0) + this.nu * (Math.abs(tA[i - 1] - tB[j - 1]) + tA[i - 2]);
                } else {
                    c1 = dp[i - 1][j] + this.d.distance(a[i - 2], a[i - 1]) + this.nu * (tA[i - 1] - tA[i - 2]) + this.lambda;
                    c2 = dp[i][j - 1] + this.d.distance(b[j - 2], b[j - 1]) + this.nu * (tB[j - 1] - tB[j - 2]) + this.lambda;
                    c3 = dp[i - 1][j - 1] + this.d.distance(a[i - 1], b[i - 1]) + this.d.distance(a[i - 2], b[j - 2]) + this.nu * (Math.abs(tA[i - 1] - tB[j - 1]) + Math.abs(tA[i - 2] - tB[j - 2]));
                }
                dp[i][j] = minimum = Math.min(c1, Math.min(c2, c3));
            }
        }
        return dp[n][m];
    }
}

