/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import ai.libs.jaicore.basic.metric.AWeightedTrigometricDistance;
import ai.libs.jaicore.basic.transform.vector.CosineTransform;
import ai.libs.jaicore.basic.transform.vector.IVectorTransform;
import org.api4.java.common.metric.IDistanceMetric;

public class TransformDistance
extends AWeightedTrigometricDistance {
    private IVectorTransform transform;
    private IDistanceMetric timeSeriesDistance;
    private IDistanceMetric baseTransformDistance;

    public TransformDistance(double alpha, IVectorTransform transform, IDistanceMetric timeSeriesDistance, IDistanceMetric transformDistance) {
        super(alpha);
        if (transform == null) {
            throw new IllegalArgumentException("Parameter transform must not be null.");
        }
        if (timeSeriesDistance == null) {
            throw new IllegalArgumentException("Parameter timeSeriesDistance must not be null.");
        }
        if (transformDistance == null) {
            throw new IllegalArgumentException("Parameter transformDistance must not be null.");
        }
        this.transform = transform;
        this.timeSeriesDistance = timeSeriesDistance;
        this.baseTransformDistance = transformDistance;
    }

    public TransformDistance(double alpha, IDistanceMetric timeSeriesDistance, IDistanceMetric transformDistance) {
        this(alpha, new CosineTransform(), timeSeriesDistance, transformDistance);
    }

    public TransformDistance(double alpha, IVectorTransform transform, IDistanceMetric distance) {
        this(alpha, transform, distance, distance);
    }

    public TransformDistance(double alpha, IDistanceMetric distance) {
        this(alpha, new CosineTransform(), distance);
    }

    @Override
    public double distance(double[] a, double[] b) {
        double[] transformA = this.transform.transform(a);
        double[] transformB = this.transform.transform(b);
        return this.getA() * this.timeSeriesDistance.distance(a, b) + this.getB() * this.baseTransformDistance.distance(transformA, transformB);
    }
}

