/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.reconstruction;

import ai.libs.jaicore.basic.reconstruction.ReconstructionInstruction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.api4.java.common.reconstruction.IReconstructionInstruction;
import org.api4.java.common.reconstruction.IReconstructionPlan;
import org.api4.java.common.reconstruction.ReconstructionException;

public class ReconstructionPlan
implements IReconstructionPlan {
    private static final long serialVersionUID = 2149341607637260587L;
    private final List<ReconstructionInstruction> instructions;

    public ReconstructionPlan() {
        this.instructions = new ArrayList<ReconstructionInstruction>(0);
    }

    @JsonCreator
    public ReconstructionPlan(@JsonProperty(value="instructions") List<ReconstructionInstruction> instructions) {
        this.instructions = instructions;
    }

    public Object reconstructObject() throws ReconstructionException {
        int n = this.instructions.size();
        Object o = this.instructions.get(0).applyToCreate();
        for (int i = 1; i < n; ++i) {
            o = this.instructions.get(i).apply(o);
        }
        return o;
    }

    public List<IReconstructionInstruction> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instructions == null ? 0 : this.instructions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReconstructionPlan other = (ReconstructionPlan)obj;
        return !(this.instructions == null ? other.instructions != null : !this.instructions.equals(other.instructions));
    }
}

