/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class FilteredIterable<X>
implements Iterable<X> {
    private Iterable<X> wrappedIterable;
    private List<Integer> filteredIndices;

    public FilteredIterable(Iterable<X> wrappedIterable, List<Integer> filteredIndices) {
        this.wrappedIterable = wrappedIterable;
        this.filteredIndices = new LinkedList<Integer>(filteredIndices);
        Collections.sort(this.filteredIndices);
    }

    @Override
    public Iterator<X> iterator() {
        return new FilteredIterator(this.wrappedIterable.iterator(), this.getFilteredIndices());
    }

    public List<Integer> getFilteredIndices() {
        return new LinkedList<Integer>(this.filteredIndices);
    }

    private class FilteredIterator
    implements Iterator<X> {
        private final Iterator<X> wrappedIterator;
        private final List<Integer> remainingFilteredInstances;
        private int currentIndex;

        private FilteredIterator(Iterator<X> wrappedIterator, List<Integer> remainingFilteredInstances) {
            this.wrappedIterator = wrappedIterator;
            this.remainingFilteredInstances = remainingFilteredInstances;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.remainingFilteredInstances.isEmpty()) {
                return false;
            }
            int nextIndex = this.remainingFilteredInstances.get(0);
            while (this.currentIndex < nextIndex) {
                this.wrappedIterator.next();
                ++this.currentIndex;
            }
            return true;
        }

        @Override
        public X next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There is no element left!");
            }
            int extractedIndex = this.remainingFilteredInstances.remove(0);
            if (extractedIndex != this.currentIndex) {
                throw new IllegalStateException("Current index does not match the extracted index from the list. Extracted: " + extractedIndex);
            }
            ++this.currentIndex;
            return this.wrappedIterator.next();
        }
    }
}

