/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class Interval
implements Serializable {
    private static final long serialVersionUID = -6928681531901708026L;
    private boolean isInteger;
    private double min;
    private double max;

    private Interval() {
        this.isInteger = true;
        this.min = 0.0;
        this.max = 0.0;
    }

    @JsonCreator
    public Interval(@JsonProperty(value="integer") boolean isInteger, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max) {
        this.isInteger = isInteger;
        this.min = min;
        this.max = max;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setInteger(boolean isInteger) {
        this.isInteger = isInteger;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public String toString() {
        return "NumericParameterDomain [isInteger=" + this.isInteger + ", min=" + this.min + ", max=" + this.max + "]";
    }

    public boolean contains(Object item) {
        Double n;
        if (!(item instanceof Number)) {
            return false;
        }
        if (item instanceof Double) {
            n = (double)((Double)item);
        } else if (item instanceof Long) {
            n = (double)((Long)item);
        } else if (item instanceof Integer) {
            n = (double)((Integer)item);
        } else {
            throw new IllegalArgumentException("No support for number type " + item.getClass());
        }
        if (this.isInteger && n != (double)n.intValue()) {
            return false;
        }
        return n >= this.min && n <= this.max;
    }

    public boolean subsumes(Interval otherInterval) {
        if (this.isInteger && !otherInterval.isInteger) {
            return false;
        }
        return this.min <= otherInterval.getMin() && this.max >= otherInterval.getMax();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isInteger ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.isInteger != other.isInteger) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min);
    }
}

