/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.sets.ElementDecorator;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.api4.java.common.attributedobjects.IListDecorator;

public class ListDecorator<L extends List<E>, E, D extends ElementDecorator<E>>
implements IListDecorator<L, E, D>,
List<D> {
    private final L list;
    private final Class<E> typeOfDecoratedItems;
    private final Class<D> typeOfDecoratingItems;
    private final Constructor<D> constructorForDecoratedItems;

    public ListDecorator(L list) {
        try {
            this.list = list;
            Type[] genericTypes = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
            this.typeOfDecoratedItems = this.getClassWithoutGenerics(genericTypes[1].getTypeName());
            this.typeOfDecoratingItems = this.getClassWithoutGenerics(genericTypes[2].getTypeName());
            Constructor<D> vConstructorForDecoratedItems = null;
            vConstructorForDecoratedItems = this.typeOfDecoratingItems.getConstructor(this.typeOfDecoratedItems);
            this.constructorForDecoratedItems = vConstructorForDecoratedItems;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not determin class without generics", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The constructor of the list class could not be invoked.", e);
        }
    }

    public Class<E> getTypeOfDecoratedItems() {
        return this.typeOfDecoratedItems;
    }

    public Class<D> getTypeOfDecoratingItems() {
        return this.typeOfDecoratingItems;
    }

    public Constructor<D> getConstructorForDecoratingItems() {
        return this.constructorForDecoratedItems;
    }

    public L getList() {
        return this.list;
    }

    private Class<?> getClassWithoutGenerics(String className) throws ClassNotFoundException {
        return Class.forName(className.replaceAll("(<[^>*]>)", ""));
    }
}

