/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.PartialOrderedSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.api4.java.common.attributedobjects.GetPropertyFailedException;
import org.api4.java.common.attributedobjects.IGetter;

public class SetUtil {
    private static final String DEFAULT_LIST_ITEM_SEPARATOR = ",";

    private SetUtil() {
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> ... set) {
        HashSet<T> union = new HashSet<T>();
        for (int i = 0; i < set.length; ++i) {
            Objects.requireNonNull(set[i]);
            union.addAll(set[i]);
        }
        return union;
    }

    public static <T> List<T> union(List<T> ... lists) {
        ArrayList<T> union = new ArrayList<T>();
        for (int i = 0; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            union.addAll(lists[i]);
        }
        return union;
    }

    public static <T> Collection<T> symmetricDifference(Collection<T> a, Collection<T> b) {
        return SetUtil.union(SetUtil.difference(a, b), SetUtil.difference(b, a));
    }

    public static <T> Collection<T> getMultiplyContainedItems(List<T> list) {
        HashSet<T> doubleEntries = new HashSet<T>();
        HashSet<T> observed = new HashSet<T>();
        for (T item : list) {
            if (observed.contains(item)) {
                doubleEntries.add(item);
                continue;
            }
            observed.add(item);
        }
        return doubleEntries;
    }

    public static <S, T extends S, U extends S> Collection<S> intersection(Collection<T> a, Collection<U> b) {
        ArrayList<Object> out = new ArrayList<Object>();
        Collection<Object> bigger = a.size() < b.size() ? b : a;
        for (Object item : a.size() >= b.size() ? b : a) {
            if (!bigger.contains(item)) continue;
            out.add(item);
        }
        return out;
    }

    public static <S, T extends S, U extends S> boolean disjoint(Collection<T> a, Collection<U> b) {
        Collection<Object> bigger = a.size() < b.size() ? b : a;
        for (Object item : a.size() >= b.size() ? b : a) {
            if (!bigger.contains(item)) continue;
            return false;
        }
        return true;
    }

    public static <T> Collection<Collection<T>> getPotenceOfSet(Collection<T> set, byte exponent) {
        ArrayList<Collection<T>> items = new ArrayList<Collection<T>>();
        for (byte i = 0; i < exponent; i = (byte)(i + 1)) {
            items.add(set);
        }
        return SetUtil.getCartesianProductOfSetsOfSameClass(items);
    }

    public static <T> Collection<Collection<T>> getCartesianProductOfSetsOfSameClass(Collection<Collection<T>> items) {
        if (items.isEmpty()) {
            return new ArrayList<Collection<T>>();
        }
        if (items.size() == 1) {
            ArrayList<Collection<T>> tuples = new ArrayList<Collection<T>>();
            for (Collection<T> set : items) {
                for (T value : set) {
                    ArrayList<T> trivialTuple = new ArrayList<T>();
                    trivialTuple.add(value);
                    tuples.add(trivialTuple);
                }
            }
            return tuples;
        }
        ArrayList<Collection<T>> subproblem = new ArrayList<Collection<T>>();
        Collection<T> unconsideredDomain = null;
        int i = 0;
        int limit = items.size();
        for (Collection<T> set : items) {
            if (i < limit - 1) {
                subproblem.add(set);
            } else if (i == limit - 1) {
                unconsideredDomain = set;
                break;
            }
            ++i;
        }
        Collection<Collection<T>> subsolution = SetUtil.getCartesianProductOfSetsOfSameClass(subproblem);
        ArrayList<Collection<T>> solution = new ArrayList<Collection<T>>();
        for (Collection<T> tuple : subsolution) {
            for (T value : unconsideredDomain) {
                ArrayList<T> newTuple = new ArrayList<T>();
                newTuple.addAll(tuple);
                newTuple.add(value);
                solution.add(newTuple);
            }
        }
        return solution;
    }

    public static <T> Collection<Collection<T>> powerset(Collection<T> items) throws InterruptedException {
        if (items.isEmpty()) {
            ArrayList<Collection<T>> setWithEmptySet = new ArrayList<Collection<T>>();
            setWithEmptySet.add(new ArrayList());
            return setWithEmptySet;
        }
        Object baseElement = null;
        ArrayList<T> restList = new ArrayList<T>();
        int i = 0;
        for (T item : items) {
            if (i == 0) {
                baseElement = item;
            } else {
                restList.add(item);
            }
            ++i;
        }
        ArrayList toAdd = new ArrayList();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted during calculation of power set");
        }
        Collection<Collection<T>> subsets = SetUtil.powerset(restList);
        for (Collection collection : subsets) {
            ArrayList additionalList = new ArrayList();
            additionalList.addAll(collection);
            additionalList.add(baseElement);
            toAdd.add(additionalList);
        }
        subsets.addAll(toAdd);
        return subsets;
    }

    public static <T> Collection<Collection<T>> getAllPossibleSubsets(Collection<T> items) {
        if (items.isEmpty()) {
            ArrayList<Collection<T>> setWithEmptySet = new ArrayList<Collection<T>>();
            setWithEmptySet.add(new ArrayList());
            return setWithEmptySet;
        }
        Object baseElement = null;
        ArrayList<T> restList = new ArrayList<T>();
        int i = 0;
        for (T item : items) {
            if (i == 0) {
                baseElement = item;
            } else {
                restList.add(item);
            }
            ++i;
        }
        Collection<Collection<T>> subsets = SetUtil.getAllPossibleSubsets(restList);
        ArrayList toAdd = new ArrayList();
        for (Collection collection : subsets) {
            ArrayList additionalList = new ArrayList();
            additionalList.addAll(collection);
            additionalList.add(baseElement);
            toAdd.add(additionalList);
        }
        subsets.addAll(toAdd);
        return subsets;
    }

    public static <T> Collection<Set<T>> subsetsOfSize(Collection<T> set, int size) throws InterruptedException {
        ArrayList<Set<T>> subsets = new ArrayList<Set<T>>();
        ArrayList<T> setAsList = new ArrayList<T>();
        setAsList.addAll(set);
        SetUtil.getSubsetOfSizeRec(setAsList, size, 0, new HashSet(), subsets);
        return subsets;
    }

    private static <T> void getSubsetOfSizeRec(List<T> superSet, int k, int idx, Set<T> current, Collection<Set<T>> solution) throws InterruptedException {
        if (current.size() == k) {
            solution.add(new HashSet<T>(current));
            return;
        }
        if (idx == superSet.size()) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted during calculation of subsets with special size");
        }
        T x = superSet.get(idx);
        current.add(x);
        SetUtil.getSubsetOfSizeRec(superSet, k, idx + 1, current, solution);
        current.remove(x);
        SetUtil.getSubsetOfSizeRec(superSet, k, idx + 1, current, solution);
    }

    public static <T> List<Set<T>> getAllPossibleSubsetsWithSizeParallely(Collection<T> superSet, int k) throws InterruptedException {
        ArrayList res = new ArrayList();
        int n = 1;
        ExecutorService pool = Executors.newFixedThreadPool(n);
        Semaphore solutionSemaphore = new Semaphore(1);
        solutionSemaphore.acquire();
        pool.submit(new SubSetComputer<T>(new ArrayList<T>(superSet), k, 0, new HashSet(), res, pool, new Semaphore(n - 1), MathExt.binomial(superSet.size(), k), solutionSemaphore));
        solutionSemaphore.acquire();
        pool.shutdown();
        return res;
    }

    private static <T> void getAllPossibleSubsetsWithSizeRecursive(List<T> superSet, int k, int idx, Set<T> current, List<Set<T>> solution) {
        if (current.size() == k) {
            solution.add(new HashSet<T>(current));
            return;
        }
        if (idx == superSet.size()) {
            return;
        }
        T x = superSet.get(idx);
        current.add(x);
        SetUtil.getAllPossibleSubsetsWithSizeRecursive(superSet, k, idx + 1, current, solution);
        current.remove(x);
        SetUtil.getAllPossibleSubsetsWithSizeRecursive(superSet, k, idx + 1, current, solution);
    }

    public static <T> List<Set<T>> getAllPossibleSubsetsWithSize(Collection<T> superSet, int k) {
        ArrayList<Set<T>> res = new ArrayList<Set<T>>();
        SetUtil.getAllPossibleSubsetsWithSizeRecursive(new ArrayList<T>(superSet), k, 0, new HashSet(), res);
        return res;
    }

    public static List<Integer> invertPermutation(List<Integer> permutation) {
        int n = permutation.size();
        ArrayList<Integer> inverse = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            inverse.add(permutation.indexOf(i));
        }
        return inverse;
    }

    public static <T> List<Integer> getPermutation(List<T> l1, List<T> l2) {
        int n = l1.size();
        if (n != l2.size()) {
            throw new IllegalArgumentException("Expecting two lists of same length!");
        }
        ArrayList<Integer> p = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            int pos = l1.indexOf(l2.get(i));
            if (pos < 0) {
                throw new IllegalArgumentException("The second list does not contain the element " + l1.get(i) + ". Cannot compute permutation between lists with different elements!");
            }
            p.add(pos);
        }
        return p;
    }

    public static <T> List<T> applyPermutation(List<T> list, List<Integer> permutation) {
        int n = list.size();
        if (permutation.size() != n) {
            throw new IllegalArgumentException("The permutation must have the same length as the list.");
        }
        ArrayList<T> out = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            out.add(list.get(permutation.get(i)));
        }
        return out;
    }

    public static <T> List<T> applyInvertedPermutation(List<T> list, List<Integer> permutation) {
        return SetUtil.applyPermutation(list, SetUtil.invertPermutation(permutation));
    }

    public static <T> Collection<List<T>> getPermutations(Collection<T> set) {
        ArrayList<List<T>> permutations = new ArrayList<List<T>>();
        ArrayList<T> setAsList = new ArrayList<T>(set);
        SetUtil.getPermutationsRec(setAsList, 0, permutations);
        return permutations;
    }

    private static <T> void getPermutationsRec(List<T> list, int pointer, Collection<List<T>> solution) {
        if (pointer == list.size()) {
            solution.add(list);
            return;
        }
        for (int i = pointer; i < list.size(); ++i) {
            ArrayList<T> permutation = new ArrayList<T>(list);
            permutation.set(pointer, list.get(i));
            permutation.set(i, list.get(pointer));
            SetUtil.getPermutationsRec(permutation, pointer + 1, solution);
        }
    }

    public static <S, T extends S, U extends S> Collection<S> difference(Collection<T> a, Collection<U> b) {
        ArrayList<T> out = new ArrayList<T>();
        for (T item : a) {
            if (b != null && b.contains(item)) continue;
            out.add(item);
        }
        return out;
    }

    public static <S, T extends S, U extends S> Collection<S> getDisjointSet(Collection<T> a, Collection<U> b) {
        ArrayList<S> out = new ArrayList<S>(SetUtil.difference(a, b));
        for (S item : SetUtil.difference(b, a)) {
            if (out.contains(item)) continue;
            out.add(item);
        }
        return out;
    }

    public static <S, T extends S, U extends S> List<S> difference(List<T> a, Collection<U> b) {
        ArrayList<T> out = new ArrayList<T>();
        for (T item : a) {
            if (b != null && b.contains(item)) continue;
            out.add(item);
        }
        return out;
    }

    public static <S, T extends S, U extends S> boolean differenceEmpty(Collection<T> a, Collection<U> b) {
        if (a == null || a.isEmpty()) {
            return true;
        }
        for (T item : a) {
            if (b.contains(item)) continue;
            return false;
        }
        return true;
    }

    public static <S, T extends S, U extends S> boolean differenceNotEmpty(Collection<T> a, Collection<U> b) {
        if (b == null) {
            return !a.isEmpty();
        }
        for (T item : a) {
            if (b.contains(item)) continue;
            return true;
        }
        return false;
    }

    public static <S, T> Collection<Pair<S, T>> cartesianProduct(Collection<S> a, Collection<T> b) {
        HashSet<Pair<S, T>> product = new HashSet<Pair<S, T>>();
        for (S item1 : a) {
            for (T item2 : b) {
                product.add(new Pair<S, T>(item1, item2));
            }
        }
        return product;
    }

    public static <T> Collection<List<T>> cartesianProduct(List<? extends Collection<T>> listOfSets) {
        return SetUtil.cartesianProductReq(new ArrayList<Collection<T>>(listOfSets));
    }

    private static <T> Collection<List<T>> cartesianProductReq(List<? extends Collection<T>> listOfSets) {
        int expectedSize = 1;
        for (Collection<T> collection : listOfSets) {
            assert (collection.size() == new HashSet<T>(collection).size()) : "One of the collection is effectively a multi-set, which is forbidden for CP computation: " + collection;
            expectedSize *= collection.size();
        }
        if (listOfSets.isEmpty()) {
            throw new IllegalArgumentException("Empty list of sets");
        }
        if (listOfSets.size() == 1) {
            HashSet<List<T>> product = new HashSet<List<T>>();
            for (T obj : listOfSets.get(0)) {
                ArrayList<T> tupleOfSize1 = new ArrayList<T>();
                tupleOfSize1.add(obj);
                product.add(tupleOfSize1);
            }
            assert (product.size() == expectedSize) : "Invalid number of expected entries! Expected " + expectedSize + " but computed " + product.size() + " for a single set: " + listOfSets.get(0);
            return product;
        }
        Collection<T> removed = listOfSets.get(listOfSets.size() - 1);
        listOfSets.remove(listOfSets.size() - 1);
        Collection<List<T>> collection = SetUtil.cartesianProduct(listOfSets);
        HashSet<List<T>> product = new HashSet<List<T>>();
        for (List<T> tuple : collection) {
            for (T item : removed) {
                ArrayList<T> newTuple = new ArrayList<T>(tuple);
                newTuple.add(item);
                product.add(newTuple);
            }
        }
        assert (product.size() == expectedSize) : "Invalid number of expected entries! Expected " + expectedSize + " but computed " + product.size();
        return product;
    }

    public static <S> Collection<List<S>> cartesianProduct(Collection<S> set, int number) throws InterruptedException {
        ArrayList<List<S>> product = new ArrayList<List<S>>();
        ArrayList<S> setAsList = new ArrayList<S>(set);
        if (number <= 1) {
            for (S elem : set) {
                ArrayList<S> tuple = new ArrayList<S>();
                tuple.add(elem);
                product.add(tuple);
            }
            return product;
        }
        for (List<S> restProduct : SetUtil.cartesianProduct(setAsList, number - 1)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            for (S elem : set) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                ArrayList<S> tuple = new ArrayList<S>(restProduct.size() + 1);
                for (S elementOfRestProduct : restProduct) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    tuple.add(elementOfRestProduct);
                }
                tuple.add(0, elem);
                product.add(tuple);
            }
        }
        return product;
    }

    public static <K, V> Collection<Pair<K, V>> relation(Collection<K> keys, Collection<V> values, Predicate<Pair<K, V>> relationPredicate) {
        HashSet<Pair<K, V>> relation = new HashSet<Pair<K, V>>();
        for (K key : keys) {
            for (V val : values) {
                Pair<K, V> p = new Pair<K, V>(key, val);
                if (!relationPredicate.test(p)) continue;
                relation.add(p);
            }
        }
        return relation;
    }

    public static <K, V> Map<K, Collection<V>> relationAsFunction(Collection<K> keys, Collection<V> values, Predicate<Pair<K, V>> relationPredicate) {
        HashMap relation = new HashMap();
        for (K key : keys) {
            relation.put(key, new HashSet());
            for (V val : values) {
                Pair<K, V> p = new Pair<K, V>(key, val);
                if (!relationPredicate.test(p)) continue;
                ((Collection)relation.get(key)).add(val);
            }
        }
        return relation;
    }

    public static <K, V> Collection<Map<K, V>> allMappings(Collection<K> domain, Collection<V> range, boolean totalsOnly, boolean injectivesOnly, boolean surjectivesOnly) throws InterruptedException {
        ArrayList<Map<K, V>> mappings = new ArrayList<Map<K, V>>();
        if (totalsOnly) {
            if (domain.isEmpty()) {
                return mappings;
            }
            ArrayList<K> domainAsList = new ArrayList<K>(domain);
            int n = domainAsList.size();
            for (List<V> reducedRange : SetUtil.cartesianProduct(range, domain.size())) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Interrupted during calculating all mappings");
                }
                boolean considerMap = true;
                HashMap map = new HashMap();
                ArrayList<V> coveredRange = new ArrayList<V>();
                for (int i = 0; i < n; ++i) {
                    V val = reducedRange.get(i);
                    if (injectivesOnly && coveredRange.contains(val)) {
                        considerMap = false;
                        break;
                    }
                    coveredRange.add(val);
                    map.put(domainAsList.get(i), val);
                }
                if (surjectivesOnly && !coveredRange.containsAll(range)) {
                    considerMap = false;
                }
                if (!considerMap) continue;
                mappings.add(map);
            }
        } else {
            for (Collection<K> reducedDomain : SetUtil.powerset(domain)) {
                mappings.addAll(SetUtil.allMappings(reducedDomain, range, true, injectivesOnly, surjectivesOnly));
            }
            if (!surjectivesOnly) {
                mappings.add(new HashMap());
            }
        }
        return mappings;
    }

    public static <K, V> Collection<Map<K, V>> allTotalMappings(Collection<K> domain, Collection<V> range) throws InterruptedException {
        return SetUtil.allMappings(domain, range, true, false, false);
    }

    public static <K, V> Collection<Map<K, V>> allPartialMappings(Collection<K> domain, Collection<V> range) throws InterruptedException {
        return SetUtil.allMappings(domain, range, false, false, false);
    }

    public static <K, V> Set<Map<K, V>> allTotalAndInjectiveMappingsWithConstraint(Collection<K> domain, Collection<V> range, Predicate<Map<K, V>> pPredicate) throws InterruptedException {
        HashSet<Map<K, V>> mappings = new HashSet<Map<K, V>>();
        if (domain.isEmpty()) {
            return mappings;
        }
        ArrayList<K> domainAsList = new ArrayList<K>(domain);
        int domainSize = domainAsList.size();
        ArrayList open = new ArrayList();
        open.add(new HashMap());
        while (!open.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupted during calculation of allTotalMappingsWithConstraint.");
            }
            Map partialMap = (Map)open.get(0);
            open.remove(0);
            int index = partialMap.keySet().size();
            if (index >= domainSize) {
                mappings.add(partialMap);
                continue;
            }
            Object key = domainAsList.get(index);
            for (V val : range) {
                if (partialMap.containsValue(val)) continue;
                HashMap extendedMap = new HashMap(partialMap);
                extendedMap.put(key, val);
                if (!pPredicate.test(extendedMap)) continue;
                open.add(extendedMap);
            }
        }
        return mappings;
    }

    public static <K, V> Set<Map<K, V>> allTotalMappingsWithLocalConstraints(Collection<K> domain, Collection<V> range, Predicate<Pair<K, V>> pPredicate) throws InterruptedException {
        Map<K, Collection<V>> pairsThatSatisfyCondition = SetUtil.relationAsFunction(domain, range, pPredicate);
        return SetUtil.allFuntionsFromFunctionallyDenotedRelation(pairsThatSatisfyCondition);
    }

    public static <K, V> Set<Map<K, V>> allFuntionsFromFunctionallyDenotedRelation(Map<K, Collection<V>> pRelation) throws InterruptedException {
        return SetUtil.allFunctionsFromFunctionallyDenotedRelationRewritingReference(new HashMap<K, Collection<V>>(pRelation));
    }

    private static <K, V> Set<Map<K, V>> allFunctionsFromFunctionallyDenotedRelationRewritingReference(Map<K, Collection<V>> pRelation) throws InterruptedException {
        HashSet<Map<K, V>> out = new HashSet<Map<K, V>>();
        if (pRelation.isEmpty()) {
            out.add(new HashMap(0, 1.0f));
            return out;
        }
        K firstKey = pRelation.keySet().iterator().next();
        Collection<V> vals = pRelation.get(firstKey);
        pRelation.remove(firstKey);
        if (pRelation.isEmpty()) {
            for (V val : vals) {
                HashMap<K, V> mapWithOneEntry = new HashMap<K, V>(1);
                mapWithOneEntry.put(firstKey, val);
                out.add(mapWithOneEntry);
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted during allFunctionsFromFunctionallyDenotedRelationRewritingReference");
        }
        Set<Map<K, V>> recursivelyObtainedFunctions = SetUtil.allFunctionsFromFunctionallyDenotedRelationRewritingReference(pRelation);
        for (Map<K, V> func : recursivelyObtainedFunctions) {
            for (V val : vals) {
                HashMap<K, V> newFunc = new HashMap<K, V>(func);
                newFunc.put(firstKey, val);
                out.add(newFunc);
            }
        }
        return out;
    }

    public static <T> void shuffle(List<T> list, long seed) {
        ArrayList<Integer> unusedItems = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            unusedItems.add(i);
        }
        ArrayList<T> copy = new ArrayList<T>();
        copy.addAll(list);
        list.clear();
        while (!unusedItems.isEmpty()) {
            int index = new Random(seed).nextInt(unusedItems.size());
            list.add(copy.get((Integer)unusedItems.get(index)));
        }
    }

    public static <T> T getRandomElement(Collection<T> set, long seed) {
        return SetUtil.getRandomElement(set, new Random(seed));
    }

    public static <T> T getRandomElement(Collection<T> set, Random random) {
        int choice = random.nextInt(set.size());
        if (set instanceof List) {
            return (T)((List)set).get(choice);
        }
        int i = 0;
        for (T elem : set) {
            if (i++ != choice) continue;
            return elem;
        }
        return null;
    }

    public static <T> T getRandomElement(List<T> list, Random random, List<Double> probabilityVector) {
        int n = list.size();
        if (probabilityVector.size() != n) {
            throw new IllegalArgumentException("Probability vector should have length " + n + " but has " + probabilityVector.size());
        }
        double alpha = (Double)probabilityVector.stream().reduce((a, b) -> a + b).get();
        List<Double> probabilities = alpha == 1.0 ? probabilityVector : probabilityVector.stream().map(d -> d / alpha).collect(Collectors.toList());
        double randomNumber = random.nextDouble();
        double accumulatedProbability = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!((accumulatedProbability += probabilities.get(i).doubleValue()) >= randomNumber)) continue;
            return list.get(i);
        }
        throw new IllegalStateException("Probability has been accumulated to " + accumulatedProbability + " but no element was returned.");
    }

    public static <T> Collection<T> getRandomSubset(Collection<T> set, int k, Random random) {
        ArrayList<T> copy = new ArrayList<T>(set);
        Collections.shuffle(copy, random);
        return copy.stream().limit(k).collect(Collectors.toList());
    }

    public static Collection<Integer> getRandomSetOfIntegers(int maxExclusive, int k, Random random) {
        ArrayList ints = new ArrayList(k);
        IntStream.range(0, maxExclusive).forEach(ints::add);
        return SetUtil.getRandomSubset(ints, k, random);
    }

    public static <T extends Comparable<T>> List<T> mergeSort(Collection<T> set) {
        if (set.isEmpty()) {
            return new ArrayList();
        }
        if (set.size() == 1) {
            ArrayList<T> result = new ArrayList<T>();
            result.addAll(set);
            return result;
        }
        ArrayList<Comparable> sublist1 = new ArrayList<Comparable>();
        ArrayList<Comparable> sublist2 = new ArrayList<Comparable>();
        int mid = (int)Math.ceil((double)set.size() / 2.0);
        int i = 0;
        for (Comparable elem : set) {
            if (i++ < mid) {
                sublist1.add(elem);
                continue;
            }
            sublist2.add(elem);
        }
        return SetUtil.mergeLists(SetUtil.mergeSort(sublist1), SetUtil.mergeSort(sublist2));
    }

    private static <T extends Comparable<T>> List<T> mergeLists(List<T> list1, List<T> list2) {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        while (!list1.isEmpty() && !list2.isEmpty()) {
            if (((Comparable)list1.get(0)).compareTo((Comparable)list2.get(0)) < 0) {
                result.add((Comparable)list1.get(0));
                list1.remove(0);
                continue;
            }
            result.add((Comparable)list2.get(0));
            list2.remove(0);
        }
        while (!list1.isEmpty()) {
            result.add((Comparable)list1.get(0));
            list1.remove(0);
        }
        while (!list2.isEmpty()) {
            result.add((Comparable)list2.get(0));
            list2.remove(0);
        }
        return result;
    }

    public static <K, V extends Comparable<V>> List<K> keySetSortedByValues(Map<K, V> map, boolean asc) {
        if (map.isEmpty()) {
            return new ArrayList();
        }
        if (map.size() == 1) {
            ArrayList<K> result = new ArrayList<K>();
            result.addAll(map.keySet());
            return result;
        }
        HashMap<K, Comparable> submap1 = new HashMap<K, Comparable>();
        HashMap<K, Comparable> submap2 = new HashMap<K, Comparable>();
        int mid = (int)Math.ceil((double)map.size() / 2.0);
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (i++ < mid) {
                submap1.put(entry.getKey(), (Comparable)entry.getValue());
                continue;
            }
            submap2.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return SetUtil.mergeMaps(SetUtil.keySetSortedByValues(submap1, asc), SetUtil.keySetSortedByValues(submap2, asc), map, asc);
    }

    private static <K, V extends Comparable<V>> List<K> mergeMaps(List<K> keys1, List<K> keys2, Map<K, V> map, boolean asc) {
        ArrayList<K> result = new ArrayList<K>();
        while (!keys1.isEmpty() && !keys2.isEmpty()) {
            double comp = ((Comparable)map.get(keys1.get(0))).compareTo((Comparable)map.get(keys2.get(0)));
            if (asc && comp < 0.0 || !asc && comp >= 0.0) {
                result.add(keys1.get(0));
                keys1.remove(0);
                continue;
            }
            result.add(keys2.get(0));
            keys2.remove(0);
        }
        while (!keys1.isEmpty()) {
            result.add(keys1.get(0));
            keys1.remove(0);
        }
        while (!keys2.isEmpty()) {
            result.add(keys2.get(0));
            keys2.remove(0);
        }
        return result;
    }

    public static int calculateNumberOfTotalOrderings(PartialOrderedSet<?> set) throws InterruptedException {
        return SetUtil.getAllTotalOrderings(set).size();
    }

    public static <E> Collection<List<E>> getAllTotalOrderings(PartialOrderedSet<E> set) throws InterruptedException {
        if (set.isEmpty()) {
            return Arrays.asList(new ArrayList());
        }
        ArrayList candidates = new ArrayList();
        HashMap order = new HashMap(set.getOrder());
        set.getLinearization();
        Collection itemsWithoutSuccessor = set.stream().filter(s -> !order.containsKey(s) || ((Set)order.get(s)).isEmpty()).collect(Collectors.toList());
        for (Object item : itemsWithoutSuccessor) {
            PartialOrderedSet<E> reducedSet = new PartialOrderedSet<E>(set);
            reducedSet.remove(item);
            for (List completionOfReducedSet : SetUtil.getAllTotalOrderings(reducedSet)) {
                completionOfReducedSet.add(item);
                candidates.add(completionOfReducedSet);
            }
        }
        return candidates;
    }

    public static String serializeAsSet(Collection<String> set) {
        return set.toString().replace("\\[", "{").replace("\\]", "}");
    }

    public static Set<String> unserializeSet(String setDescriptor) {
        HashSet<String> items = new HashSet<String>();
        for (String item : setDescriptor.substring(1, setDescriptor.length() - 1).split(DEFAULT_LIST_ITEM_SEPARATOR)) {
            if (item.trim().isEmpty()) continue;
            items.add(item.trim());
        }
        return items;
    }

    public static List<String> unserializeList(String listDescriptor) {
        if (listDescriptor == null) {
            throw new IllegalArgumentException("Invalid list descriptor NULL.");
        }
        if (!listDescriptor.startsWith("[") || !listDescriptor.endsWith("]")) {
            throw new IllegalArgumentException("Invalid list descriptor \"" + listDescriptor + "\". Must start with '[' and end with ']'");
        }
        ArrayList<String> items = new ArrayList<String>();
        for (String item : listDescriptor.substring(1, listDescriptor.length() - 1).split(DEFAULT_LIST_ITEM_SEPARATOR)) {
            if (item.trim().isEmpty()) continue;
            items.add(item.trim());
        }
        return items;
    }

    public static Interval unserializeInterval(String intervalDescriptor) {
        List<String> interval = SetUtil.unserializeList(intervalDescriptor);
        double min = Double.parseDouble(interval.get(0));
        return new Interval(min, interval.size() == 1 ? min : Double.valueOf(interval.get(1)));
    }

    public static <T> List<T> getInvertedCopyOfList(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            copy.add(list.get(n - i - 1));
        }
        return copy;
    }

    public static <T> List<T> addAndGet(List<T> list, T item) {
        list.add(item);
        return list;
    }

    public static <T, U> Map<U, Collection<T>> groupCollectionByAttribute(Collection<T> collection, IGetter<T, U> getter) throws InterruptedException, GetPropertyFailedException {
        HashMap<Object, Collection> groupedCollection = new HashMap<Object, Collection>();
        for (T i : collection) {
            groupedCollection.computeIfAbsent(getter.getPropertyOf(i), t -> new ArrayList()).add(i);
        }
        return groupedCollection;
    }

    public static List<String> explode(String stringList) {
        return SetUtil.explode(stringList, DEFAULT_LIST_ITEM_SEPARATOR);
    }

    public static List<String> explode(String stringList, String separator) {
        return Arrays.stream(stringList.split(separator)).collect(Collectors.toList());
    }

    public static String implode(Collection<? extends Object> collection, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object object : collection) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(object + "");
        }
        return sb.toString();
    }

    public static boolean doesStringCollectionOnlyContainNumbers(Collection<String> strings) {
        try {
            for (String s : strings) {
                Double.parseDouble(s);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Type getGenericClass(Collection<?> c) {
        ParameterizedType stringListType = (ParameterizedType)c.getClass().getGenericSuperclass();
        return stringListType.getActualTypeArguments()[0];
    }

    public static <T extends Comparable<T>> int argmax(List<T> list) {
        int n = list.size();
        Comparable best = null;
        int index = -1;
        for (int i = 0; i < n; ++i) {
            Comparable x = (Comparable)list.get(i);
            if (best != null && best.compareTo(x) <= 0) continue;
            best = x;
            index = i;
        }
        return index;
    }

    public static <T extends Comparable<T>> int argmax(T[] arr) {
        return SetUtil.argmax(Arrays.asList(arr));
    }

    public static <T extends Comparable<T>> int argmin(List<T> list) {
        int n = list.size();
        Comparable best = null;
        int index = -1;
        for (int i = 0; i < n; ++i) {
            Comparable x = (Comparable)list.get(i);
            if (best != null && best.compareTo(x) >= 0) continue;
            best = x;
            index = i;
        }
        return index;
    }

    public static <T extends Comparable<T>> int argmin(T[] arr) {
        return SetUtil.argmin(Arrays.asList(arr));
    }

    public static int argmin(int[] arr) {
        int minIndex = -1;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int argmax(int[] arr) {
        int maxIndex = -1;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static <T> Collection<List<T>> getSubGridRelationFromDomains(List<List<T>> hypercubeDomains, int numSamples) {
        return SetUtil.getSubGridRelationFromRelation(SetUtil.cartesianProduct(hypercubeDomains), numSamples);
    }

    public static <T> Collection<List<T>> getSubGridRelationFromRelation(Collection<List<T>> relation, int numSamples) {
        long totalSize = relation.size();
        if (totalSize < (long)numSamples) {
            throw new IllegalArgumentException("Cannot generate a sample of size " + numSamples + " for a hypercube with only " + totalSize + " entries.");
        }
        int stepSize = (int)Math.floor((double)totalSize * 1.0 / (double)numSamples);
        int i = 0;
        ArrayList<List<T>> subSample = new ArrayList<List<T>>();
        for (List<T> tuple : relation) {
            if (i % stepSize == 0) {
                subSample.add(tuple);
            }
            ++i;
            if (subSample.size() != numSamples) continue;
            break;
        }
        return subSample;
    }

    public static double sum(Collection<? extends Number> nums) {
        double sum = 0.0;
        for (Number number : nums) {
            if (number == null) {
                return Double.NaN;
            }
            sum += number.doubleValue();
        }
        return sum;
    }

    private static class SubSetComputer<T>
    implements Runnable {
        private List<T> superSet;
        private ExecutorService pool;
        private int k;
        private int idx;
        private Set<T> current;
        private List<Set<T>> allSolutions;
        private Semaphore semThreads;
        private Semaphore semComplete;
        private long goalSize;

        public SubSetComputer(List<T> superSet, int k, int idx, Set<T> current, List<Set<T>> allSolutions, ExecutorService pool, Semaphore sem, long goalSize, Semaphore semComplete) {
            this.superSet = superSet;
            this.pool = pool;
            this.k = k;
            this.idx = idx;
            this.current = current;
            this.allSolutions = allSolutions;
            this.semThreads = sem;
            this.semComplete = semComplete;
            this.goalSize = goalSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Set<T>> localSolutions = new ArrayList<Set<T>>();
            this.performStep(this.superSet, this.k, this.idx, this.current, localSolutions);
            List<Set<T>> list = this.allSolutions;
            synchronized (list) {
                this.allSolutions.addAll(localSolutions);
                if ((long)this.allSolutions.size() == this.goalSize) {
                    this.semComplete.release();
                }
            }
            this.semThreads.release();
        }

        public void performStep(List<T> superSet, int k, int idx, Set<T> current, List<Set<T>> solution) {
            if (current.size() == k) {
                solution.add(new HashSet<T>(current));
                return;
            }
            if (idx == superSet.size()) {
                return;
            }
            T x = superSet.get(idx);
            current.add(x);
            if (this.semThreads.tryAcquire()) {
                this.pool.submit(new SubSetComputer<T>(superSet, k, idx + 1, new HashSet<T>(current), this.allSolutions, this.pool, this.semThreads, this.goalSize, this.semComplete));
                current.remove(x);
                if (this.semThreads.tryAcquire()) {
                    this.pool.submit(new SubSetComputer<T>(superSet, k, idx + 1, new HashSet<T>(current), this.allSolutions, this.pool, this.semThreads, this.goalSize, this.semComplete));
                } else {
                    this.performStep(superSet, k, idx + 1, current, solution);
                }
            } else {
                this.performStep(superSet, k, idx + 1, current, solution);
                current.remove(x);
                if (this.semThreads.tryAcquire()) {
                    this.pool.submit(new SubSetComputer<T>(superSet, k, idx + 1, new HashSet<T>(current), this.allSolutions, this.pool, this.semThreads, this.goalSize, this.semComplete));
                } else {
                    this.performStep(superSet, k, idx + 1, current, solution);
                }
            }
        }
    }
}

