/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.transform.vector;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.basic.transform.vector.IVectorTransform;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class NormalizeByStdTransform
implements IVectorTransform {
    @Override
    public double[] transform(double[] input) {
        List t = Arrays.stream(input).mapToObj(Double::valueOf).collect(Collectors.toList());
        double standardDeviation = StatisticsUtil.standardDeviation(t);
        if (standardDeviation == 0.0) {
            return new double[input.length];
        }
        double[] normalizedT = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            normalizedT[i] = input[i] / standardDeviation;
        }
        return normalizedT;
    }
}

