/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.transform.vector;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.basic.transform.vector.IVectorTransform;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ZTransform
implements IVectorTransform {
    public static final double EPSILON = 1.0E-7;

    @Override
    public double[] transform(double[] input) {
        List t = Arrays.stream(input).mapToObj(Double::valueOf).collect(Collectors.toList());
        double mean = StatisticsUtil.mean(t);
        double standardDeviation = StatisticsUtil.standardDeviation(t);
        if (-1.0E-7 < standardDeviation && standardDeviation < 1.0E-7) {
            return new double[input.length];
        }
        double[] zTransformedT = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            zTransformedT[i] = (input[i] - mean) / standardDeviation;
        }
        return zTransformedT;
    }
}

