/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.concurrent;

import ai.libs.jaicore.basic.sets.SetUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ThreadObserver
extends Thread {
    private final List<Thread> threadsThatHaveBeenActiveAtLastObservation = new ArrayList<Thread>();
    private final PrintStream stream;

    public ThreadObserver(PrintStream stream) {
        super("ThreadObserver");
        this.stream = stream;
    }

    @Override
    public void run() {
        try {
            while (true) {
                List currentlyActiveThreads = Thread.getAllStackTraces().keySet().stream().sorted((t1, t2) -> t1.getName().compareTo(t2.getName())).collect(Collectors.toList());
                List<Thread> newThreads = SetUtil.difference(currentlyActiveThreads, this.threadsThatHaveBeenActiveAtLastObservation);
                List<Thread> goneThreads = SetUtil.difference(this.threadsThatHaveBeenActiveAtLastObservation, currentlyActiveThreads);
                if (!newThreads.isEmpty()) {
                    this.stream.println("" + System.currentTimeMillis());
                    this.stream.println("New Threads:");
                    for (Thread t : newThreads) {
                        this.stream.println("\t" + t.getName() + ": " + t.getThreadGroup());
                    }
                }
                if (!goneThreads.isEmpty()) {
                    this.stream.println("Gone Threads:");
                    for (Thread t : goneThreads) {
                        this.stream.println("\t" + t.getName() + ": " + t.getThreadGroup());
                    }
                }
                this.threadsThatHaveBeenActiveAtLastObservation.clear();
                this.threadsThatHaveBeenActiveAtLastObservation.addAll(currentlyActiveThreads);
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

