/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.concurrent;

import ai.libs.jaicore.concurrent.WrappingTrackableTimerTask;
import java.util.TimerTask;

public abstract class TrackableTimerTask
extends TimerTask {
    private boolean canceled;
    private long lastExecution = -1L;
    private boolean finished;

    public static TrackableTimerTask get(TimerTask tt) {
        return new WrappingTrackableTimerTask(tt);
    }

    @Override
    public final void run() {
        this.lastExecution = System.currentTimeMillis();
        this.exec();
        this.finished = true;
    }

    public abstract void exec();

    @Override
    public boolean cancel() {
        this.canceled = true;
        return super.cancel();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public long getLastExecution() {
        return this.lastExecution;
    }

    public boolean hasBeenExecuted() {
        return this.lastExecution >= 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

