/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graph;

import ai.libs.jaicore.basic.sets.SetUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Graph<T> {
    private T root;
    private final Map<T, Set<T>> successors = new HashMap<T, Set<T>>();
    private final Map<T, Set<T>> predecessors = new HashMap<T, Set<T>>();
    private boolean useBackPointers = true;
    private boolean useForwardPointers = true;

    public Graph() {
    }

    public Graph(T node) {
        this();
        this.addItem(node);
    }

    public Graph(Collection<T> nodes) {
        this();
        for (T node : nodes) {
            this.addItem(node);
        }
    }

    public Graph(Graph<T> toClone) {
        this();
        for (T i : toClone.getItems()) {
            for (T i2 : toClone.getSuccessors(i)) {
                this.addEdge(i, i2);
            }
        }
    }

    public void addItem(T item) {
        if (this.getItems().contains(item)) {
            throw new IllegalArgumentException("Cannot add node " + item + " to graph since such a node exists already. Current nodes: " + this.getItems().stream().map(e -> "\n\t" + e).collect(Collectors.joining()));
        }
        if (this.useForwardPointers) {
            this.successors.put(item, new HashSet());
        }
        if (this.useBackPointers) {
            this.predecessors.put(item, new HashSet());
        }
        if (this.root == null) {
            this.root = item;
        }
        if (!this.hasItem(item)) {
            throw new IllegalStateException("Just added node " + item + " does not respond positively on a call to hasItem");
        }
    }

    public void addPath(List<T> path) {
        T parent = null;
        for (T node : path) {
            if (!this.hasItem(node)) {
                this.addItem(node);
            }
            if (parent != null && !this.getPredecessors(node).contains(parent)) {
                this.addEdge(parent, node);
            }
            parent = node;
        }
    }

    public Set<T> getItems() {
        return Collections.unmodifiableSet(this.successors.keySet());
    }

    public boolean hasItem(T item) {
        if (this.useForwardPointers) {
            return this.successors.containsKey(item);
        }
        if (this.useBackPointers) {
            return this.predecessors.containsKey(item);
        }
        throw new IllegalStateException("Graph must use forward pointers and/or backward pointers.");
    }

    public boolean hasEdge(T from, T to) {
        return this.successors.containsKey(from) && this.successors.get(from).contains(to);
    }

    public boolean hasPath(List<T> nodes) {
        T last = null;
        for (T current : nodes) {
            if (last != null && !this.hasEdge(last, current)) {
                return false;
            }
            last = current;
        }
        return true;
    }

    public void removeItem(T item) {
        if (this.useForwardPointers) {
            this.successors.remove(item);
            this.successors.forEach((k, v) -> v.remove(item));
        }
        if (this.useBackPointers) {
            this.predecessors.remove(item);
            this.predecessors.forEach((k, v) -> v.remove(item));
        }
    }

    public void addEdge(T from, T to) {
        if (!this.hasItem(from)) {
            this.addItem(from);
        }
        if (!this.hasItem(to)) {
            this.addItem(to);
        }
        if (this.useForwardPointers) {
            this.successors.get(from).add(to);
        }
        if (this.useBackPointers) {
            this.predecessors.computeIfAbsent(to, n -> new HashSet()).add(from);
        }
        if (to == this.root) {
            this.root = null;
            if (this.predecessors.get(from).isEmpty()) {
                this.root = from;
            }
        }
    }

    public void removeEdge(T from, T to) {
        this.checkNodeExistence(from);
        this.checkNodeExistence(to);
        this.successors.get(from).remove(to);
        this.predecessors.get(to).remove(from);
        if (from == this.root) {
            this.root = null;
            if (this.getPredecessors(to).isEmpty()) {
                this.root = to;
            }
        }
    }

    public Set<T> getSuccessors(T item) {
        if (!this.useForwardPointers) {
            throw new UnsupportedOperationException();
        }
        if (!this.successors.containsKey(item)) {
            throw new IllegalStateException("No predecessor map defined for node " + item);
        }
        return Collections.unmodifiableSet(this.successors.get(item));
    }

    public Set<T> getPredecessors(T item) {
        if (!this.useBackPointers) {
            throw new UnsupportedOperationException();
        }
        if (!this.predecessors.containsKey(item)) {
            throw new IllegalStateException("No predecessor map defined for node " + item);
        }
        return Collections.unmodifiableSet(this.predecessors.get(item));
    }

    public Set<T> getSiblings(T item) {
        HashSet<T> siblings = new HashSet<T>();
        for (T parent : this.getPredecessors(item)) {
            for (T child : this.getSuccessors(parent)) {
                if (child.equals(item)) continue;
                siblings.add(child);
            }
        }
        return siblings;
    }

    public Set<T> getDescendants(T item) {
        ArrayList<T> open = new ArrayList<T>();
        open.add(item);
        HashSet descendants = new HashSet();
        while (!open.isEmpty()) {
            Object next = open.remove(0);
            descendants.add(next);
            this.getSuccessors(next).forEach(open::add);
        }
        descendants.remove(item);
        return descendants;
    }

    public Set<T> getConnected(T item) {
        HashSet<T> connected = new HashSet<T>();
        connected.addAll(this.getSuccessors(item));
        connected.addAll(this.getPredecessors(item));
        return connected;
    }

    private void checkNodeExistence(T item) {
        if (!this.hasItem(item)) {
            throw new IllegalArgumentException("Cannot perform operation on node " + item + ", which does not exist!");
        }
    }

    public final Collection<T> getSources() {
        AbstractCollection sources;
        if (this.useBackPointers) {
            sources = new ArrayList();
            for (Map.Entry<T, Set<T>> parentRelations : this.predecessors.entrySet()) {
                if (!parentRelations.getValue().isEmpty()) continue;
                sources.add(parentRelations.getKey());
            }
        } else if (this.useForwardPointers) {
            sources = new HashSet<T>(this.successors.keySet());
            for (Map.Entry<T, Set<T>> childRelations : this.successors.entrySet()) {
                sources.removeAll((Collection)childRelations.getValue());
            }
        } else {
            throw new UnsupportedOperationException("Neither forward edges nor backward edges are contained.");
        }
        return sources;
    }

    public final T getRoot() {
        return this.root;
    }

    public final Collection<T> getSinks() {
        AbstractCollection sinks;
        if (this.useForwardPointers) {
            sinks = new ArrayList();
            for (Map.Entry<T, Set<T>> childRelations : this.successors.entrySet()) {
                if (!childRelations.getValue().isEmpty()) continue;
                sinks.add(childRelations.getKey());
            }
        } else if (this.useBackPointers) {
            sinks = new HashSet<T>(this.predecessors.keySet());
            for (Map.Entry<T, Set<T>> parentRelations : this.predecessors.entrySet()) {
                sinks.removeAll((Collection)parentRelations.getValue());
            }
        } else {
            throw new UnsupportedOperationException("Neither forward edges nor backward edges are contained.");
        }
        return sinks;
    }

    public final void addGraph(Graph<T> g) {
        for (Object t : SetUtil.difference(g.getItems(), this.getItems())) {
            this.addItem(t);
        }
        for (Object t1 : g.getItems()) {
            for (Object t2 : g.getSuccessors(t1)) {
                this.addEdge(t1, t2);
            }
        }
    }

    public boolean isEmpty() {
        return this.useForwardPointers ? this.successors.isEmpty() : this.predecessors.isEmpty();
    }

    public String getLineBasedStringRepresentation() {
        return this.getLineBasedStringRepresentation(1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.predecessors.hashCode();
        result = 31 * result + this.successors.hashCode();
        result = 31 * result + (this.useBackPointers ? 1231 : 1237);
        result = 31 * result + (this.useForwardPointers ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Graph other = (Graph)obj;
        if (!this.predecessors.equals(other.predecessors)) {
            return false;
        }
        if (!this.successors.equals(other.successors)) {
            return false;
        }
        if (this.useBackPointers != other.useBackPointers) {
            return false;
        }
        return this.useForwardPointers == other.useForwardPointers;
    }

    public String getLineBasedStringRepresentation(int offset) {
        StringBuilder sb = new StringBuilder();
        for (T source : this.getSources()) {
            sb.append(this.getLineBasedStringRepresentation(source, offset, new ArrayList<Boolean>()));
        }
        return sb.toString();
    }

    private String getLineBasedStringRepresentation(T node, int outerOffset, List<Boolean> childrenOffset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < outerOffset; ++i) {
            sb.append("\t");
        }
        for (boolean lastChild : childrenOffset) {
            sb.append(lastChild ? " " : "|");
            sb.append("      ");
        }
        if (!childrenOffset.isEmpty()) {
            sb.append("+----- ");
        }
        sb.append(node.toString());
        Set<T> successorsOfThisNode = this.getSuccessors(node);
        int n = successorsOfThisNode.size();
        int i = 1;
        for (Object successor : successorsOfThisNode) {
            sb.append("\n");
            ArrayList<Boolean> childrenOffsetCopy = new ArrayList<Boolean>(childrenOffset);
            childrenOffsetCopy.add(i++ == n);
            sb.append(this.getLineBasedStringRepresentation(successor, outerOffset, childrenOffsetCopy));
        }
        return sb.toString();
    }

    public boolean isGraphSane() {
        boolean allNodesContained = this.getItems().stream().allMatch(this::hasItem);
        if (!allNodesContained) {
            assert (allNodesContained) : "Not every node n in the node map have positive responses for a call of hasItem(n)";
            return false;
        }
        boolean allSuccessorsContained = this.getItems().stream().allMatch(n -> this.getSuccessors(n).stream().allMatch(this::hasItem));
        if (!allSuccessorsContained) {
            assert (allSuccessorsContained) : "There is a node in the graph such that not every successor n of it has a positive response for a call of hasItem(n)";
            return false;
        }
        return true;
    }

    public boolean isUseBackPointers() {
        return this.useBackPointers;
    }

    public void setUseBackPointers(boolean useBackPointers) {
        this.useBackPointers = useBackPointers;
        if (!useBackPointers) {
            this.predecessors.clear();
        }
    }

    public boolean isUseForwardPointers() {
        return this.useForwardPointers;
    }

    public void setUseForwardPointers(boolean useForwardPointers) {
        this.useForwardPointers = useForwardPointers;
        if (!useForwardPointers) {
            this.successors.clear();
        }
    }
}

