/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logging;

import ai.libs.jaicore.basic.sets.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LoggerUtil {
    public static final String LOGGER_NAME_EXAMPLE = "example";
    public static final String LOGGER_NAME_TESTER = "tester";
    public static final String LOGGER_NAME_TESTEDALGORITHM = "testedalgorithm";
    public static final String LOGGER_NAME_EVALUATOR = "evaluator";
    public static final String LOGGER_NAME_EVALUATEDALGORITHM = "evaluatedalgorithm";
    private static final String INDENTED_LINEBREAK = "\n\t\t";

    private LoggerUtil() {
    }

    public static String getExceptionInfo(Throwable e) {
        return LoggerUtil.getExceptionInfo(e, new ArrayList<Pair<String, Object>>());
    }

    public static String getExceptionInfo(Throwable e, List<Pair<String, Object>> additionalInformationObjects) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tError class: ");
        sb.append(e.getClass().getName());
        sb.append("\n\tError message: ");
        if (e.getMessage() != null) {
            sb.append(e.getMessage().replace("\n", INDENTED_LINEBREAK));
        } else {
            sb.append("NaN");
        }
        sb.append("\n\tError trace:");
        Arrays.asList(e.getStackTrace()).forEach(ste -> sb.append(INDENTED_LINEBREAK + ste.toString()));
        Throwable current = e;
        while (current.getCause() != null) {
            current = current.getCause();
            sb.append("\n\tCaused by " + current.getClass().getName() + " with message " + current.getMessage() + ". Stack trace of the cause:");
            Arrays.asList(current.getStackTrace()).forEach(ste -> sb.append(INDENTED_LINEBREAK + ste.toString()));
        }
        if (additionalInformationObjects != null) {
            for (Pair<String, Object> additionalObject : additionalInformationObjects) {
                sb.append("\n\t" + additionalObject.getX() + INDENTED_LINEBREAK);
                sb.append(additionalObject.getY().toString().replace("\n", INDENTED_LINEBREAK));
            }
        }
        return sb.toString();
    }

    public static String logException(Throwable e) {
        return LoggerUtil.getExceptionInfo(e, new ArrayList<Pair<String, Object>>());
    }
}

