/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.cannibals;

public class CannibalProblem {
    private final boolean boatOnLeft;
    private final int missionariesOnLeft;
    private final int cannibalsOnLeft;
    private final int missionariesOnRight;
    private final int cannibalsOnRight;

    public CannibalProblem(boolean boatOnLeft, int missionariesOnLeft, int cannibalsOnLeft, int missionariesOnRight, int cannibalsOnRight) {
        this.boatOnLeft = boatOnLeft;
        this.missionariesOnLeft = missionariesOnLeft;
        this.cannibalsOnLeft = cannibalsOnLeft;
        this.missionariesOnRight = missionariesOnRight;
        this.cannibalsOnRight = cannibalsOnRight;
        if (missionariesOnLeft < 0) {
            throw new IllegalArgumentException("Number of missionaries on left must be non-negative!");
        }
        if (missionariesOnRight < 0) {
            throw new IllegalArgumentException("Number of missionaries on right must be non-negative!");
        }
        if (cannibalsOnLeft < 0) {
            throw new IllegalArgumentException("Number of cannibales on left must be non-negative!");
        }
        if (cannibalsOnRight < 0) {
            throw new IllegalArgumentException("Number of cannibales on right must be non-negative!");
        }
    }

    public boolean isLost() {
        return this.missionariesOnLeft > 0 && this.missionariesOnLeft < this.cannibalsOnLeft || this.missionariesOnRight > 0 && this.missionariesOnRight < this.cannibalsOnRight;
    }

    public boolean isWon() {
        return this.missionariesOnLeft == 0 && this.cannibalsOnLeft == 0;
    }

    public int getMissionariesOnLeft() {
        return this.missionariesOnLeft;
    }

    public int getCannibalsOnLeft() {
        return this.cannibalsOnLeft;
    }

    public int getMissionariesOnRight() {
        return this.missionariesOnRight;
    }

    public int getCannibalsOnRight() {
        return this.cannibalsOnRight;
    }

    public boolean isBoatOnLeft() {
        return this.boatOnLeft;
    }

    public int getTotalNumberOfPeople() {
        return this.cannibalsOnLeft + this.cannibalsOnRight + this.missionariesOnLeft + this.missionariesOnRight;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.missionariesOnLeft > 0) {
            sb.append(this.missionariesOnLeft + "M");
        }
        if (this.cannibalsOnLeft > 0) {
            sb.append(this.cannibalsOnLeft + "C");
        }
        sb.append(" ");
        if (this.missionariesOnRight > 0) {
            sb.append(this.missionariesOnRight + "M");
        }
        if (this.cannibalsOnRight > 0) {
            sb.append(this.cannibalsOnRight + "C");
        }
        return sb.toString();
    }
}

