/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.enhancedttsp;

import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSP;
import ai.libs.jaicore.problems.enhancedttsp.ITSPLocationGenerator;
import ai.libs.jaicore.problems.enhancedttsp.Location;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class EnhancedTTSPGenerator {
    private final ITSPLocationGenerator locationGenerator;

    public EnhancedTTSPGenerator(ITSPLocationGenerator locationGenerator) {
        this.locationGenerator = locationGenerator;
    }

    public EnhancedTTSP generate(int n, int maxDistance, int seed) {
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Number of locations must not exceed 32767");
        }
        List<Boolean> blockedHours = Arrays.asList(true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true);
        List<Location> locations = this.locationGenerator.getLocations(n, 0.0, 0.0, maxDistance, 0.1);
        Collections.shuffle(locations, new Random(seed));
        return new EnhancedTTSP(locations, 0, blockedHours, 8.0, 4.5, 1.0, 10.0);
    }
}

