/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.enhancedttsp.locationgenerator;

import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPUtil;
import ai.libs.jaicore.problems.enhancedttsp.ITSPLocationGenerator;
import ai.libs.jaicore.problems.enhancedttsp.Location;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class RandomLocationGenerator
implements ITSPLocationGenerator {
    private final Random random;

    public RandomLocationGenerator(Random random) {
        this.random = random;
    }

    @Override
    public List<Location> getLocations(int n, double centerX, double centerY, double radius, double minDistance) {
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Number of locations must not exceed 32767");
        }
        LinkedList<Location> locations = new LinkedList<Location>();
        for (short i = 0; i < n; i = (short)(i + 1)) {
            Location nl;
            while (!EnhancedTTSPUtil.getLocationsInDistance(locations, nl = new Location(i, centerX + this.random.nextDouble() * radius * (double)(this.random.nextBoolean() ? 1 : -1), centerY + this.random.nextDouble() * radius * (double)(this.random.nextBoolean() ? 1 : -1)), minDistance).isEmpty()) {
            }
            locations.add(nl);
        }
        return locations;
    }
}

