/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.npuzzle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class NPuzzleState {
    protected int[][] board;
    protected int emptyX;
    protected int emptyY;

    public NPuzzleState(int dim) {
        this(dim, 0);
    }

    public NPuzzleState(int dim, int seed) {
        this.board = new int[dim][dim];
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < dim * dim; ++i) {
            numbers.add(i);
        }
        Collections.shuffle(numbers, new Random(seed));
        int c = 0;
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                this.board[i][j] = (Integer)numbers.get(c++);
            }
        }
    }

    public NPuzzleState(int[][] board, int emptyX, int emptyY) {
        this.board = board;
        this.emptyX = emptyX;
        this.emptyY = emptyY;
    }

    public int[][] getBoard() {
        return this.board;
    }

    public int getEmptyX() {
        return this.emptyX;
    }

    public int getEmptyY() {
        return this.emptyY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this.board.length; ++j) {
            sb.append("----");
        }
        sb.append("\n");
        for (int i = 0; i < this.board.length; ++i) {
            int j;
            sb.append("| ");
            for (j = 0; j < this.board.length; ++j) {
                sb.append(this.board[i][j] + " | ");
            }
            sb.append("\n");
            for (j = 0; j < this.board.length; ++j) {
                sb.append("----");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getNumberOfWrongTiles() {
        int wrongTiles = 0;
        int x = 1;
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board.length; ++j) {
                if (i == this.board.length - 1 && j == this.board.length - 1) {
                    x = 0;
                }
                if (x != this.board[i][j]) {
                    ++wrongTiles;
                }
                ++x;
            }
        }
        return wrongTiles;
    }

    public double getDistance() {
        double d = 0.0;
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board.length; ++j) {
                int tile = this.board[i][j];
                double x = (double)tile / (double)this.board.length;
                int y = tile % this.board.length - 1;
                if (x % 1.0 == 0.0) {
                    x -= 1.0;
                }
                x = Math.floor(x);
                if (y < 0) {
                    y = this.board.length - 1;
                }
                if (tile == 0) continue;
                double h1 = Math.abs((double)i - x);
                double h2 = Math.abs(j - y);
                double d1 = h1 + h2;
                d += d1;
            }
        }
        return d;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.board);
        result = 31 * result + this.emptyX;
        result = 31 * result + this.emptyY;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NPuzzleState other = (NPuzzleState)obj;
        if (!Arrays.deepEquals((Object[])this.board, (Object[])other.board)) {
            return false;
        }
        if (this.emptyX != other.emptyX) {
            return false;
        }
        return this.emptyY == other.emptyY;
    }
}

