/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.samegame;

import ai.libs.jaicore.problems.samegame.SameGameCell;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortRBTreeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SameGameState {
    private final short score;
    private final byte[][] board;
    private final short numPieces;

    public static byte[][] getBoardAsBytes(String boardAsString) {
        List lines = Arrays.stream(boardAsString.split("\n")).filter(l -> !l.trim().isEmpty()).collect(Collectors.toList());
        byte[][] board = new byte[lines.size()][((String)lines.get(0)).length()];
        for (int i = 0; i < lines.size(); ++i) {
            String trimmedLine = ((String)lines.get(i)).trim();
            board[i] = new byte[trimmedLine.length()];
            for (int j = 0; j < trimmedLine.length(); ++j) {
                board[i][j] = Byte.parseByte(trimmedLine.substring(j, j + 1));
            }
        }
        return board;
    }

    public SameGameState(String board) {
        this(SameGameState.getBoardAsBytes(board));
    }

    public SameGameState(byte[][] board) {
        this.score = 0;
        this.board = board;
        short tmpNumPieces = 0;
        for (int i = 0; i < board.length; ++i) {
            for (int j = 0; j < board[i].length; ++j) {
                if (board[i][j] == 0) continue;
                tmpNumPieces = (short)(tmpNumPieces + 1);
            }
        }
        this.numPieces = tmpNumPieces;
    }

    private SameGameState(short score, byte[][] board, short numPieces) {
        this.score = score;
        this.board = board;
        this.numPieces = numPieces;
    }

    public SameGameState getStateAfterMove(Collection<SameGameCell> block) {
        if (block.size() < 2) {
            throw new IllegalArgumentException("Removed blocks must have size at least 2.");
        }
        byte[][] boardCopy = new byte[this.board.length][this.board[0].length];
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                boardCopy[i] = Arrays.copyOf(this.board[i], this.board[i].length);
            }
        }
        Collection<SameGameCell> removedPieces = block;
        if (removedPieces.size() < 2) {
            throw new IllegalArgumentException();
        }
        int maximumAffectedRow = 0;
        ShortRBTreeSet colsToDrop = new ShortRBTreeSet();
        for (SameGameCell piece : removedPieces) {
            boardCopy[piece.getRow()][piece.getCol()] = 0;
            colsToDrop.add((short)piece.getCol());
            maximumAffectedRow = Math.max(maximumAffectedRow, piece.getCol());
        }
        ShortIterator shortIterator = colsToDrop.iterator();
        while (shortIterator.hasNext()) {
            short c = (Short)shortIterator.next();
            int fallHeightInColumn = 0;
            boolean touchedFirstEmpty = false;
            for (int r = this.board.length - 1; r >= 0; --r) {
                if (boardCopy[r][c] == 0) {
                    ++fallHeightInColumn;
                    touchedFirstEmpty = true;
                    continue;
                }
                if (!touchedFirstEmpty) continue;
                boardCopy[r + fallHeightInColumn][c] = boardCopy[r][c];
                boardCopy[r][c] = 0;
            }
        }
        int offset = 0;
        for (int c = 0; c < boardCopy[0].length; ++c) {
            if (boardCopy[boardCopy.length - 1][c] == 0) {
                ++offset;
                continue;
            }
            if (offset <= 0) continue;
            for (int r = 0; r < boardCopy.length; ++r) {
                boardCopy[r][c - offset] = boardCopy[r][c];
                boardCopy[r][c] = 0;
            }
        }
        short newScore = (short)(this.score + (int)Math.pow((double)removedPieces.size() - 2.0, 2.0));
        short newNumPieces = (short)(this.numPieces - removedPieces.size());
        if (!SameGameState.isMovePossible(boardCopy)) {
            newScore = newNumPieces == 0 ? (short)(newScore + 1000) : (short)((double)newScore - Math.pow((double)newNumPieces - 2.0, 2.0));
        }
        return new SameGameState(newScore, boardCopy, newNumPieces);
    }

    public SameGameState getStateAfterMove(byte row, byte col) {
        return this.getStateAfterMove(this.getAllConnectedPiecesOfSameColor(row, col));
    }

    public List<SameGameCell> getAllConnectedPiecesOfSameColor(byte row, byte col) {
        if (this.board[row][col] == 0) {
            throw new IllegalArgumentException("There is no block in row " + row + " and col " + col);
        }
        ArrayList<SameGameCell> removed = new ArrayList<SameGameCell>();
        removed.add(new SameGameCell(row, col));
        this.getAllConnectedPiecesOfSameColor(row, col, removed);
        return removed;
    }

    private boolean getAllConnectedPiecesOfSameColor(byte row, byte col, List<SameGameCell> countedPieces) {
        byte color = this.board[row][col];
        boolean addedOne = false;
        byte colorLeft = col > 0 ? this.board[row][col - 1] : (byte)0;
        SameGameCell leftCell = new SameGameCell(row, (byte)(col - 1));
        if (colorLeft == color && !countedPieces.contains(leftCell)) {
            countedPieces.add(leftCell);
            this.getAllConnectedPiecesOfSameColor(row, leftCell.getCol(), countedPieces);
            addedOne = true;
        }
        byte colorRight = col < this.board[row].length - 1 ? this.board[row][col + 1] : (byte)0;
        SameGameCell rightCell = new SameGameCell(row, (byte)(col + 1));
        if (colorRight == color && !countedPieces.contains(rightCell)) {
            countedPieces.add(rightCell);
            this.getAllConnectedPiecesOfSameColor(row, rightCell.getCol(), countedPieces);
            addedOne = true;
        }
        byte colorUp = row > 0 ? this.board[row - 1][col] : (byte)0;
        SameGameCell upCell = new SameGameCell((byte)(row - 1), col);
        if (colorUp == color && !countedPieces.contains(upCell)) {
            countedPieces.add(upCell);
            this.getAllConnectedPiecesOfSameColor(upCell.getRow(), col, countedPieces);
            addedOne = true;
        }
        byte colorDown = row < this.board.length - 1 ? this.board[row + 1][col] : (byte)0;
        SameGameCell downCell = new SameGameCell((byte)(row + 1), col);
        if (colorDown == color && !countedPieces.contains(downCell)) {
            countedPieces.add(downCell);
            this.getAllConnectedPiecesOfSameColor(downCell.getRow(), col, countedPieces);
            addedOne = true;
        }
        return addedOne;
    }

    public String getBoardAsString() {
        StringBuilder sb = new StringBuilder();
        for (int row = 0; row < this.board.length; ++row) {
            for (int col = 0; col < this.board[row].length; ++col) {
                sb.append(this.board[row][col]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public byte[][] getBoard() {
        return this.board;
    }

    public int getNumRows() {
        return this.board.length;
    }

    public int getNumCols() {
        return this.board[0].length;
    }

    public Collection<Collection<SameGameCell>> getBlocksOfPieces() {
        ArrayList<Collection<SameGameCell>> identifiedBlocks = new ArrayList<Collection<SameGameCell>>();
        HashMap<SameGameCell, Integer> blocksOfCells = new HashMap<SameGameCell, Integer>();
        SameGameCell[][] cellObjects = new SameGameCell[this.board.length][this.board[0].length];
        byte lastRow = -1;
        IntArraySet indicesToRemove = new IntArraySet();
        for (byte row = 0; row < this.board.length; row = (byte)((byte)(row + 1))) {
            int lastCol = -1;
            for (int col = 0; col < this.board[row].length; col = (byte)(col + 1)) {
                byte color = this.board[row][col];
                if (color != 0) {
                    SameGameCell cell;
                    cellObjects[row][col] = cell = new SameGameCell(row, (byte)col);
                    if (row > 0 && this.board[lastRow][col] == color) {
                        int leftBlockId;
                        int topBlockId = (Integer)blocksOfCells.get(cellObjects[lastRow][col]);
                        blocksOfCells.put(cell, topBlockId);
                        ((Collection)identifiedBlocks.get(topBlockId)).add(cell);
                        assert (lastCol == col - 1);
                        if (col > 0 && this.board[row][lastCol] == color && identifiedBlocks.get(leftBlockId = ((Integer)blocksOfCells.get(cellObjects[row][lastCol])).intValue()) != identifiedBlocks.get(topBlockId)) {
                            ((Collection)identifiedBlocks.get(topBlockId)).addAll((Collection)identifiedBlocks.get(leftBlockId));
                            identifiedBlocks.set(leftBlockId, (Collection)identifiedBlocks.get(topBlockId));
                            indicesToRemove.add(leftBlockId);
                        }
                    } else if (col > 0 && this.board[row][lastCol] == color) {
                        int leftBlockId = (Integer)blocksOfCells.get(cellObjects[row][lastCol]);
                        blocksOfCells.put(cell, leftBlockId);
                        ((Collection)identifiedBlocks.get(leftBlockId)).add(cell);
                    } else {
                        int blockId = identifiedBlocks.size();
                        ArrayList<SameGameCell> block = new ArrayList<SameGameCell>();
                        block.add(cell);
                        blocksOfCells.put(cell, blockId);
                        identifiedBlocks.add(block);
                    }
                }
                lastCol = col;
            }
            lastRow = row;
        }
        Iterator iterator = indicesToRemove.stream().sorted((i1, i2) -> Integer.compare(i2, i1)).collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            int r = (Integer)iterator.next();
            identifiedBlocks.remove(r);
        }
        return identifiedBlocks;
    }

    public short getScore() {
        return this.score;
    }

    public int getNumPieces() {
        return this.numPieces;
    }

    public static boolean isMovePossible(byte[][] board) {
        for (int row = 0; row < board.length; ++row) {
            for (int col = 0; col < board[row].length; ++col) {
                if (!SameGameState.canCellBeSelected(board, row, col)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMovePossible() {
        return SameGameState.isMovePossible(this.board);
    }

    public boolean canCellBeSelected(int row, int col) {
        return SameGameState.canCellBeSelected(this.board, row, col);
    }

    public static boolean canCellBeSelected(byte[][] board, int row, int col) {
        byte color = board[row][col];
        if (color == 0) {
            return false;
        }
        if (row > 0 && board[row - 1][col] == color) {
            return true;
        }
        if (row < board.length - 1 && board[row + 1][col] == color) {
            return true;
        }
        if (col < board[row].length - 1 && board[row][col + 1] == color) {
            return true;
        }
        return col > 0 && board[row][col - 1] == color;
    }

    public Map<Integer, Integer> getNumberOfPiecesPerColor() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int row = 0; row < this.board.length; ++row) {
            for (int col = 0; col < this.board[row].length; ++col) {
                byte color = this.board[row][col];
                if (color == 0) continue;
                map.put(Integer.valueOf(color), map.computeIfAbsent(Integer.valueOf(color), c -> 0) + 1);
            }
        }
        return map;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.board);
        result = 31 * result + this.score;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SameGameState other = (SameGameState)obj;
        if (!Arrays.deepEquals((Object[])this.board, (Object[])other.board)) {
            return false;
        }
        return this.score == other.score;
    }
}

